/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import org.apache.commons.lang3.Validate;

public class BooleanArrayBinding
extends BooleanBinding {
    private BindingMode bindingMode;
    private List<? extends BooleanExpression> dependencies = new ArrayList<BooleanExpression>();

    public <T extends BooleanExpression> BooleanArrayBinding(BindingMode bindingMode, T ... booleans) {
        Validate.notNull((Object)((Object)bindingMode));
        this.bindingMode = bindingMode;
        if (booleans != null) {
            this.setDependencies(Arrays.asList(booleans));
        }
    }

    public BooleanArrayBinding(BindingMode bindingMode, Collection<? extends BooleanExpression> booleans) {
        Validate.notNull((Object)((Object)bindingMode));
        this.bindingMode = bindingMode;
        if (booleans != null) {
            this.setDependencies(booleans);
        }
    }

    public void unbind() {
        this.setDependencies(Collections.EMPTY_LIST);
    }

    public void addDependency(BooleanExpression newDependency) {
        this.dependencies.add((BooleanExpression)newDependency);
        super.bind(new Observable[]{newDependency});
        super.invalidate();
    }

    public final void setDependencies(Collection<? extends BooleanExpression> newDependencies) {
        super.unbind((Observable[])this.dependencies.toArray(new BooleanExpression[0]));
        this.dependencies = new ArrayList<BooleanExpression>(newDependencies);
        super.bind((Observable[])newDependencies.toArray(new BooleanExpression[0]));
    }

    protected boolean computeValue() {
        if (this.bindingMode == BindingMode.AND) {
            return this.computeAnd();
        }
        return this.computeOr();
    }

    private boolean computeAnd() {
        for (BooleanExpression booleanExpression : this.dependencies) {
            if (booleanExpression.get()) continue;
            return false;
        }
        return true;
    }

    private boolean computeOr() {
        for (BooleanExpression booleanExpression : this.dependencies) {
            if (!booleanExpression.get()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String s = "BooleanArrayBinding(mode=" + (Object)((Object)this.bindingMode) + ", booleans=";
        for (BooleanExpression booleanExpression : this.dependencies) {
            s = s + booleanExpression + ",";
        }
        return s;
    }

    public static enum BindingMode {
        AND,
        OR;

    }
}

