/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.table;

import com.anahata.jfx.bind.table.BindingTableView;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableView;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class BindingTableViewUtils {
    public static void bindReadOnly(@NonNull ObservableValue<? extends Boolean> ov, TableView ... tableViews) {
        if (ov == null) {
            throw new NullPointerException("ov");
        }
        Validate.notEmpty((Object[])tableViews, (String)"No TableView objects were passed", (Object[])new Object[0]);
        for (TableView tableView : tableViews) {
            Validate.isTrue((tableView.getUserData() != null ? 1 : 0) != 0, (String)"The TableView %s had a null UserData", (Object[])new Object[]{tableView});
            Validate.isTrue((boolean)(tableView.getUserData() instanceof BindingTableView), (String)"The TableView %s had a UserData that was not a BindingTableView, it was a %s", (Object[])new Object[]{tableView, tableView.getUserData().getClass().getName()});
            BindingTableView btv = (BindingTableView)tableView.getUserData();
            btv.readOnlyProperty().bind(ov);
        }
    }

    public static void bindReadOnly(@NonNull ObservableValue<? extends Boolean> ov, List<TableView> tableViews) {
        if (ov == null) {
            throw new NullPointerException("ov");
        }
        Validate.notEmpty(tableViews, (String)"No TableView objects were passed", (Object[])new Object[0]);
        for (TableView tableView : tableViews) {
            Validate.isTrue((tableView.getUserData() != null ? 1 : 0) != 0, (String)"The TableView %s had a null UserData", (Object[])new Object[]{tableView});
            Validate.isTrue((boolean)(tableView.getUserData() instanceof BindingTableView), (String)"The TableView %s had a UserData that was not a BindingTableView, it was a %s", (Object[])new Object[]{tableView, tableView.getUserData().getClass().getName()});
            BindingTableView btv = (BindingTableView)tableView.getUserData();
            btv.readOnlyProperty().bind(ov);
        }
    }

    private BindingTableViewUtils() {
    }
}

