/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.converter.string;

import com.anahata.jfx.bind.converter.Converter;
import com.anahata.util.date.DateUtil;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateConverter
implements Converter<Date, LocalDate> {
    private static final Logger log = LoggerFactory.getLogger(LocalDateConverter.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM);

    @Override
    public String format(String value) {
        return value;
    }

    private LocalDate getLocalDate(Date date) {
        if (date != null) {
            LocalDate ld = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            return ld;
        }
        return null;
    }

    private Date getDate(LocalDate ldt) {
        if (ldt != null) {
            return DateUtil.toDate((LocalDate)ldt);
        }
        return null;
    }

    @Override
    public Date getAsDomainModelValue(Object node, LocalDate nodeModelValue) {
        Date d = this.getDate(nodeModelValue);
        return d;
    }

    @Override
    public LocalDate getAsNodeModelValue(Object node, Date domainModelValue) {
        LocalDate ldt = this.getLocalDate(domainModelValue);
        return ldt;
    }
}

