/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetBean {
    private static final Logger log = LoggerFactory.getLogger(TargetBean.class);
    private final Validator validator;
    private final String id;
    private final ObjectProperty<?> bean;
    private final boolean autoBind;
    private boolean requiresValidation = true;
    private Set<ConstraintViolation<Object>> validations = Collections.emptySet();
    private Set<ConstraintViolation<Object>> unpublishedValidations = Collections.emptySet();

    public TargetBean(Validator validator, String id, ObjectProperty<?> bean, boolean autoBind) {
        this.validator = validator;
        this.id = id;
        this.bean = bean;
        this.autoBind = autoBind;
    }

    public void validationConstraintIgnored(ConstraintViolation<Object> sv) {
        this.unpublishedValidations.remove(sv);
        log.debug("validationIgnored {}, unpublished {}", sv, this.unpublishedValidations);
    }

    public void validationContraintPublished(ConstraintViolation<Object> sv) {
        this.unpublishedValidations.remove(sv);
        log.debug("validationPublished {}, unpublished {}", sv, this.unpublishedValidations);
    }

    public Set<ConstraintViolation<Object>> validate(Class<?> ... groups) {
        long ts = System.currentTimeMillis();
        if (this.requiresValidation) {
            if (this.bean.getValue() == null) {
                this.validations = Collections.emptySet();
            } else {
                log.trace("Validating {} ", this.bean.getValue());
                this.validations = this.validator.validate(this.bean.getValue(), (Class[])groups);
            }
            this.unpublishedValidations = new HashSet<ConstraintViolation<Object>>();
            this.unpublishedValidations.addAll(this.validations);
            this.requiresValidation = false;
        }
        log.trace("validation = {} ms", (Object)(System.currentTimeMillis() - ts));
        return this.validations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetBean)) {
            return false;
        }
        TargetBean other = (TargetBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TargetBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 0 : $id.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    public ObjectProperty<?> getBean() {
        return this.bean;
    }

    public boolean isAutoBind() {
        return this.autoBind;
    }

    public boolean isRequiresValidation() {
        return this.requiresValidation;
    }

    public void setRequiresValidation(boolean requiresValidation) {
        this.requiresValidation = requiresValidation;
    }

    public Set<ConstraintViolation<Object>> getUnpublishedValidations() {
        return this.unpublishedValidations;
    }
}

