/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import com.anahata.jfx.DelegatingControl;
import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.table.BindingTableView;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.control.TableView;
import org.apache.commons.lang3.Validate;

public class BindUtils {
    public static boolean isBindForm(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof TableView && ((TableView)object).getUserData() != null) {
            object = ((TableView)object).getUserData();
        }
        return object instanceof BindForm;
    }

    public static BindForm getBindForm(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof TableView && ((TableView)object).getUserData() != null) {
            object = ((TableView)object).getUserData();
        }
        return object instanceof BindForm ? (BindForm)object : null;
    }

    public static Set<Object> getAllControllers(Object ... objects) {
        if (objects == null) {
            return Collections.emptySet();
        }
        HashSet<Object> controllers = new HashSet<Object>(objects.length);
        for (Object object : objects) {
            TableView tv;
            controllers.add(object);
            if (object instanceof DelegatingControl) {
                DelegatingControl dc = (DelegatingControl)object;
                controllers.add(dc.getController());
            }
            if (!(object instanceof TableView) || (tv = (TableView)object).getUserData() == null || !(tv.getUserData() instanceof BindingTableView)) continue;
            controllers.add(tv.getUserData());
        }
        return controllers;
    }

    public static <T> void bindBlocking(final Binder binder, final ObservableList<T> source, final ObservableList<T> target) {
        Validate.notNull((Object)binder);
        Validate.notNull(source);
        Validate.notNull(target);
        source.addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                boolean block = binder.isBlock();
                binder.setBlock(true);
                target.setAll((Collection)source);
                binder.setBlock(block);
            }
        });
    }

    private BindUtils() {
    }
}

