/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import org.apache.commons.lang3.Validate;

public class GridPaneUtils {
    public static void manageGridFormCells(BooleanExpression visible, Node ... nodes) {
        Validate.notNull((Object)visible, (String)"visible is required", (Object[])new Object[0]);
        Validate.notEmpty((Object[])nodes, (String)"at least one node must be specfied", (Object[])new Object[0]);
        for (Node node : nodes) {
            Node leftNode = GridPaneUtils.getLeftNode(node);
            GridPaneUtils.manageGridCells((GridPane)node.getParent(), visible, leftNode, node);
        }
    }

    public static void manageGridCells(final GridPane gridPane, final BooleanExpression visible, Node ... nodes) {
        Validate.notNull((Object)gridPane, (String)"gridPane is required", (Object[])new Object[0]);
        Validate.notNull((Object)visible, (String)"visible is required", (Object[])new Object[0]);
        Validate.notNull((Object)nodes, (String)"nodes are required", (Object[])new Object[0]);
        Validate.noNullElements((Object[])nodes, (String)"Node contains a null element", (Object[])new Object[0]);
        for (final Node node : nodes) {
            final Integer columnIndex = GridPane.getColumnIndex((Node)node);
            final Integer rowIndex = GridPane.getRowIndex((Node)node);
            if (rowIndex >= gridPane.getRowConstraints().size()) {
                throw new IllegalArgumentException("Node " + node + " id=" + node.getId() + " doesn't have an associated row constraint at index " + rowIndex + " on the grid pane.");
            }
            RowConstraints rc = (RowConstraints)gridPane.getRowConstraints().get(rowIndex.intValue());
            final double minHeight = rc.getMinHeight();
            final double maxHeight = rc.getMaxHeight();
            final double prefHeight = rc.getPrefHeight();
            node.visibleProperty().bind((ObservableValue)visible);
            node.managedProperty().bind((ObservableValue)node.visibleProperty());
            node.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                    GridPaneUtils.manageGridCell(gridPane, node, columnIndex, rowIndex, minHeight, maxHeight, prefHeight, newValue);
                }
            });
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    GridPaneUtils.manageGridCell(gridPane, node, columnIndex, rowIndex, minHeight, maxHeight, prefHeight, visible.getValue());
                }
            });
        }
    }

    private static void manageGridCell(GridPane gridPane, Node node, Integer columnIndex, Integer rowIndex, double minHeight, double maxHeight, double prefHeight, boolean value) {
        RowConstraints rc = (RowConstraints)gridPane.getRowConstraints().get(rowIndex.intValue());
        if (value) {
            GridPane.setConstraints((Node)node, (int)columnIndex, (int)rowIndex);
            rc.setMinHeight(minHeight);
            rc.setMaxHeight(maxHeight);
            rc.setPrefHeight(prefHeight);
        } else {
            GridPane.setColumnIndex((Node)node, null);
            GridPane.setRowIndex((Node)node, null);
            rc.setMinHeight(0.0);
            rc.setMaxHeight(0.0);
            rc.setPrefHeight(0.0);
        }
    }

    public static Node getNode(GridPane gridPane, int row, int column) {
        for (Node node : gridPane.getChildren()) {
            int r = GridPane.getRowIndex((Node)node);
            int c = GridPane.getColumnIndex((Node)node);
            if (r != row || c != column) continue;
            return node;
        }
        return null;
    }

    public static Node getLeftNode(Node node) {
        GridPane gridPane = (GridPane)node.getParent();
        int row = GridPane.getRowIndex((Node)node);
        int col = GridPane.getColumnIndex((Node)node);
        return GridPaneUtils.getNode(gridPane, row, col - 1);
    }

    public static void bindFieldAndLabelVisible(ObservableValue<Boolean> visible, Node ... nodes) {
        for (Node node : nodes) {
            node.visibleProperty().bind(visible);
            GridPaneUtils.getLeftNode(node).visibleProperty().bind(visible);
        }
    }

    public static void bindRowHeightToComponentHeight(final Region region) {
        final GridPane gridPane = (GridPane)region.getParent();
        final RowConstraints rc = (RowConstraints)gridPane.getRowConstraints().get(GridPane.getRowIndex((Node)region).intValue());
        region.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                rc.setMinHeight(t1.doubleValue());
                rc.setMaxHeight(t1.doubleValue());
                gridPane.requestLayout();
                gridPane.layout();
                region.layout();
                region.requestLayout();
            }
        });
    }

    private GridPaneUtils() {
    }
}

