/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.jfx.TextAreaDialog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogUtils {
    private static final Logger log = LoggerFactory.getLogger(DialogUtils.class);

    public static void showError(Window owner, String title, String headerText, String contentText) {
        DialogUtils.showAlert(owner, Alert.AlertType.ERROR, title, headerText, contentText);
    }

    public static void showInformation(Window owner, String title, String headerText, String contentText) {
        DialogUtils.showAlert(owner, Alert.AlertType.INFORMATION, title, headerText, contentText);
    }

    public static void showWarning(Window owner, String title, String headerText, String contentText) {
        DialogUtils.showAlert(owner, Alert.AlertType.WARNING, title, headerText, contentText);
    }

    public static void showAlert(Window owner, Alert.AlertType alertType, String title, String headerText, String contentText) {
        Alert alert = new Alert(alertType);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        alert.getDialogPane().getChildren().stream().filter(node -> node instanceof Label).forEach(node -> ((Label)node).setMinHeight(Double.NEGATIVE_INFINITY));
        alert.setResizable(true);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.initOwner(owner);
        alert.showAndWait();
    }

    public static Optional<ButtonType> showConfirmation(Window owner, String title, String headerText, String contentText) {
        return DialogUtils.showConfirmation(owner, title, headerText, contentText, new ButtonType[0]);
    }

    public static Optional<ButtonType> showConfirmation(Window owner, String title, String headerText, String contentText, ButtonType ... buttonTypes) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        alert.setContentText(contentText);
        if (buttonTypes != null && buttonTypes.length > 0) {
            alert.getButtonTypes().setAll((Object[])buttonTypes);
        }
        alert.getDialogPane().getChildren().stream().filter(node -> node instanceof Label).forEach(node -> ((Label)node).setMinHeight(Double.NEGATIVE_INFINITY));
        alert.initModality(Modality.WINDOW_MODAL);
        alert.initOwner(owner);
        alert.setResizable(true);
        Optional ret = alert.showAndWait();
        return ret;
    }

    public static void showExceptionDialog(Window owner, Throwable ex, String title) {
        DialogUtils.showExceptionDialog(owner, ex, title, title);
    }

    public static void showExceptionDialog(Window owner, Throwable ex, String title, String headerText) {
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle(title);
        alert.setHeaderText(headerText);
        alert.setContentText(ex.getMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        String exceptionText = sw.toString();
        Label label = new Label("The exception stacktrace was:");
        TextArea textArea = new TextArea(exceptionText);
        textArea.setEditable(false);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setPrefWidth(700.0);
        alert.getDialogPane().setExpandableContent((Node)expContent);
        alert.initModality(Modality.WINDOW_MODAL);
        alert.initOwner(owner);
        alert.showAndWait();
    }

    public static String showTextAreaDialog(Window owner, String title, String headerText, String contentLabel, String content) {
        TextAreaDialog dialog = new TextAreaDialog(content);
        dialog.setTitle(title);
        dialog.setHeaderText(headerText);
        dialog.setContentText(contentLabel);
        Optional result = dialog.showAndWait();
        return result.isPresent() ? (String)result.get() : null;
    }

    public static String showTextInputDialog(Window owner, String title, String headerText, String contentLabel, String content) {
        TextInputDialog dialog = new TextInputDialog(content);
        dialog.setTitle(title);
        dialog.setHeaderText(headerText);
        dialog.setContentText(contentLabel);
        Optional result = dialog.showAndWait();
        return result.isPresent() ? (String)result.get() : null;
    }

    private DialogUtils() {
    }
}

