/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.nodemodel;

import com.anahata.jfx.bind.nodemodel.AutoCompleteTextFieldNodeModel;
import com.anahata.jfx.bind.nodemodel.BigDecimalFieldNodeModel;
import com.anahata.jfx.bind.nodemodel.BigDecimalLabelNodeModel;
import com.anahata.jfx.bind.nodemodel.ButtonNodeModel;
import com.anahata.jfx.bind.nodemodel.CalendarTimeTextFieldNodeModel;
import com.anahata.jfx.bind.nodemodel.CheckBoxNodeModel;
import com.anahata.jfx.bind.nodemodel.ChoiceBoxNodeModel;
import com.anahata.jfx.bind.nodemodel.ComboBoxNodeModel;
import com.anahata.jfx.bind.nodemodel.DatePickerNodeModel;
import com.anahata.jfx.bind.nodemodel.HyperlinkNodeModel;
import com.anahata.jfx.bind.nodemodel.ImageViewNodeModel;
import com.anahata.jfx.bind.nodemodel.InitializableNodeModel;
import com.anahata.jfx.bind.nodemodel.LabelNodeModel;
import com.anahata.jfx.bind.nodemodel.ListViewNodeModel;
import com.anahata.jfx.bind.nodemodel.LocalDateTimeNodeModel;
import com.anahata.jfx.bind.nodemodel.NodeModel;
import com.anahata.jfx.bind.nodemodel.PasswordFieldNodeModel;
import com.anahata.jfx.bind.nodemodel.ProgressBarNodeModel;
import com.anahata.jfx.bind.nodemodel.PropertyNodeModel;
import com.anahata.jfx.bind.nodemodel.RadioButtonNodeModel;
import com.anahata.jfx.bind.nodemodel.SimpleMetroArcGaugeNodeModel;
import com.anahata.jfx.bind.nodemodel.SliderNodeModel;
import com.anahata.jfx.bind.nodemodel.TableViewNodeModel;
import com.anahata.jfx.bind.nodemodel.TextInputControlNodeModel;
import com.anahata.jfx.bind.nodemodel.TextNodeModel;
import com.anahata.jfx.bind.nodemodel.ToggleButtonNodeModel;
import com.anahata.jfx.bind.nodemodel.ToggleGroupNodeModel;
import com.anahata.jfx.scene.control.AutoCompleteTextField;
import com.anahata.util.cdi.Cdi;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import jfxtras.labs.scene.control.BigDecimalField;
import jfxtras.labs.scene.control.BigDecimalLabel;
import jfxtras.labs.scene.control.gauge.linear.SimpleMetroArcGauge;
import jfxtras.scene.control.CalendarTimeTextField;
import jfxtras.scene.control.LocalDateTimeTextField;
import org.apache.commons.lang3.Validate;

public class NodeModelFactory {
    private static final Map<Class<?>, Class<? extends NodeModel>> DEFAULT_MODELS = new HashMap();
    private static final Map<Class<?>, Class<? extends NodeModel>> USER_MODELS = new HashMap();

    public static void registerNodeModel(Class<?> nodeClass, Class<? extends NodeModel> nodeModelClass) {
        Validate.notNull(nodeClass);
        Validate.notNull(nodeModelClass);
        USER_MODELS.put(nodeClass, nodeModelClass);
    }

    public static NodeModel getNodeModel(Object node) {
        if (node instanceof NodeModel) {
            return (NodeModel)node;
        }
        Class<? extends NodeModel> modelClass = USER_MODELS.get(node.getClass());
        if (modelClass == null) {
            modelClass = DEFAULT_MODELS.get(node.getClass());
        }
        if (modelClass == null && node instanceof Property) {
            modelClass = PropertyNodeModel.class;
        }
        Validate.isTrue((modelClass != null ? 1 : 0) != 0, (String)"Could not get a model class for node class %s", (Object[])new Object[]{node.getClass()});
        NodeModel nodeModel = (NodeModel)Cdi.get(modelClass, (Annotation[])new Annotation[0]);
        if (nodeModel instanceof InitializableNodeModel) {
            InitializableNodeModel inm = (InitializableNodeModel)nodeModel;
            inm.setNode(node);
        }
        return nodeModel;
    }

    static {
        DEFAULT_MODELS.put(TextField.class, TextInputControlNodeModel.class);
        DEFAULT_MODELS.put(TextArea.class, TextInputControlNodeModel.class);
        DEFAULT_MODELS.put(BigDecimalField.class, BigDecimalFieldNodeModel.class);
        DEFAULT_MODELS.put(SimpleMetroArcGauge.class, SimpleMetroArcGaugeNodeModel.class);
        DEFAULT_MODELS.put(ProgressBar.class, ProgressBarNodeModel.class);
        DEFAULT_MODELS.put(Slider.class, SliderNodeModel.class);
        DEFAULT_MODELS.put(BigDecimalLabel.class, BigDecimalLabelNodeModel.class);
        DEFAULT_MODELS.put(CheckBox.class, CheckBoxNodeModel.class);
        DEFAULT_MODELS.put(ToggleGroup.class, ToggleGroupNodeModel.class);
        DEFAULT_MODELS.put(ImageView.class, ImageViewNodeModel.class);
        DEFAULT_MODELS.put(ComboBox.class, ComboBoxNodeModel.class);
        DEFAULT_MODELS.put(ChoiceBox.class, ChoiceBoxNodeModel.class);
        DEFAULT_MODELS.put(ToggleButton.class, ToggleButtonNodeModel.class);
        DEFAULT_MODELS.put(Hyperlink.class, HyperlinkNodeModel.class);
        DEFAULT_MODELS.put(AutoCompleteTextField.class, AutoCompleteTextFieldNodeModel.class);
        DEFAULT_MODELS.put(PasswordField.class, PasswordFieldNodeModel.class);
        DEFAULT_MODELS.put(Label.class, LabelNodeModel.class);
        DEFAULT_MODELS.put(Text.class, TextNodeModel.class);
        DEFAULT_MODELS.put(CalendarTimeTextField.class, CalendarTimeTextFieldNodeModel.class);
        DEFAULT_MODELS.put(DatePicker.class, DatePickerNodeModel.class);
        DEFAULT_MODELS.put(TableView.class, TableViewNodeModel.class);
        DEFAULT_MODELS.put(ListView.class, ListViewNodeModel.class);
        DEFAULT_MODELS.put(RadioButton.class, RadioButtonNodeModel.class);
        DEFAULT_MODELS.put(Button.class, ButtonNodeModel.class);
        DEFAULT_MODELS.put(LocalDateTimeTextField.class, LocalDateTimeNodeModel.class);
    }
}

