/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class TextAreaDialog
extends Dialog<String> {
    private final GridPane grid;
    private final Label label;
    private final TextArea textArea;
    private final String defaultValue;

    public TextAreaDialog() {
        this("");
    }

    public TextAreaDialog(@NamedArg(value="defaultValue") String defaultValue) {
        DialogPane dialogPane = this.getDialogPane();
        this.textArea = new TextArea(defaultValue);
        this.textArea.setWrapText(true);
        this.textArea.setMaxWidth(Double.MAX_VALUE);
        GridPane.setHgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        GridPane.setFillWidth((Node)this.textArea, (Boolean)true);
        this.label = TextAreaDialog.createContentLabel(dialogPane.getContentText());
        this.label.setPrefWidth(-1.0);
        this.label.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        this.defaultValue = defaultValue;
        this.grid = new GridPane();
        this.grid.setHgap(10.0);
        this.grid.setMaxWidth(Double.MAX_VALUE);
        this.grid.setAlignment(Pos.CENTER_LEFT);
        dialogPane.contentTextProperty().addListener(o -> this.updateGrid());
        this.setTitle("Title");
        dialogPane.setHeaderText("Header");
        dialogPane.getStyleClass().add((Object)"text-input-dialog");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.updateGrid();
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data = dialogButton == null ? null : dialogButton.getButtonData();
            return data == ButtonBar.ButtonData.OK_DONE ? this.textArea.getText() : null;
        });
    }

    static Label createContentLabel(String text) {
        Label label = new Label(text);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.getStyleClass().add((Object)"content");
        label.setWrapText(true);
        label.setPrefWidth(360.0);
        return label;
    }

    public final TextArea getEditor() {
        return this.textArea;
    }

    public final String getDefaultValue() {
        return this.defaultValue;
    }

    private void updateGrid() {
        this.grid.getChildren().clear();
        this.grid.add((Node)this.label, 0, 0);
        this.grid.add((Node)this.textArea, 1, 0);
        this.getDialogPane().setContent((Node)this.grid);
        Platform.runLater(() -> this.textArea.requestFocus());
    }
}

