/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnahataBindings {
    private static final Logger log = LoggerFactory.getLogger(AnahataBindings.class);

    public static BooleanExpression in(ObjectExpression oe, Object ... values) {
        Validate.notNull((Object)oe, (String)"oe is required", (Object[])new Object[0]);
        Validate.notNull((Object)values, (String)"values is required", (Object[])new Object[0]);
        Validate.notEmpty((Object[])values, (String)"at least one value is required", (Object[])new Object[0]);
        BooleanBinding ret = null;
        for (Object value : values) {
            ret = ret == null ? oe.isEqualTo(value) : ret.or((ObservableBooleanValue)oe.isEqualTo(value));
        }
        return ret;
    }

    public static BooleanExpression or(BooleanExpression ... booleanExpressions) {
        Validate.notNull((Object)booleanExpressions, (String)"oe is required", (Object[])new Object[0]);
        Object ret = null;
        for (BooleanExpression be : booleanExpressions) {
            ret = ret == null ? be : ret.or((ObservableBooleanValue)be);
        }
        return ret;
    }

    public static BooleanBinding isInstanceOf(final ObservableObjectValue<?> oov, final Class<?> clazz) {
        Validate.notNull(oov);
        Validate.notNull(clazz);
        return new BooleanBinding(){
            {
                super.bind(new Observable[]{oov});
            }

            public void dispose() {
                super.unbind(new Observable[]{oov});
            }

            protected boolean computeValue() {
                log.debug("oov= {}", (Object)oov);
                return oov == null ? false : clazz.isInstance(oov.get());
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList((Object)oov);
            }
        };
    }

    public static BooleanBinding isInstanceOf(final ObservableObjectValue<?> oov, final Class<?> ... clazzes) {
        Validate.notNull(oov);
        Validate.noNullElements((Object[])clazzes);
        return new BooleanBinding(){
            {
                super.bind(new Observable[]{oov});
            }

            public void dispose() {
                super.unbind(new Observable[]{oov});
            }

            protected boolean computeValue() {
                log.debug("oov= {}", (Object)oov);
                if (oov == null) {
                    return false;
                }
                Object obj = oov.get();
                for (Class c : clazzes) {
                    if (!c.isInstance(obj)) continue;
                    return true;
                }
                return false;
            }

            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList((Object)oov);
            }
        };
    }

    private AnahataBindings() {
    }
}

