/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class FieldSetLayout
extends StackPane {
    private static final String DEFAULT_STYLE_CLASS = "field-set";
    private static final String CSS_PROPERTY_TITLE_POSITION = "-fx-title-position";
    private static final String CSS_PROPERTY_EDGE_DISTANCE = "-fx-edge-distance";
    private static final String PADDING_8 = "padding-8";
    private Label titleLabel = new Label();
    private StackPane leftCorner;
    private StackPane rightCorner;
    private StackPane border;
    private final StringProperty title = new SimpleStringProperty((Object)this, "title", ""){

        protected void invalidated() {
            FieldSetLayout.this.titleLabel.setText(this.get());
        }
    };
    private DoubleProperty edgeDistance;
    private ObjectProperty<HPos> titlePosition;

    public FieldSetLayout() {
        this("");
    }

    public FieldSetLayout(String title) {
        this.setTitle(title);
        this.init();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public final void setTitle(String value) {
        this.title.set((Object)value);
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public DoubleProperty edgeDistanceProperty() {
        if (this.edgeDistance == null) {
            this.edgeDistance = new StyleableDoubleProperty(20.0){

                public Object getBean() {
                    return FieldSetLayout.this;
                }

                public String getName() {
                    return "edgeDistance";
                }

                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return StyleableProperties.EDGE_DISTANCE;
                }
            };
        }
        return this.edgeDistance;
    }

    public final void setEdgeDistance(double value) {
        this.edgeDistanceProperty().set(value);
    }

    public final double getEdgeDistance() {
        return this.edgeDistance == null ? 10.0 : this.edgeDistance.get();
    }

    public ObjectProperty<HPos> titlePositionProperty() {
        if (this.titlePosition == null) {
            this.titlePosition = new StyleableObjectProperty<HPos>(HPos.LEFT){

                protected void invalidated() {
                    FieldSetLayout.this.requestLayout();
                }

                public Object getBean() {
                    return FieldSetLayout.this;
                }

                public String getName() {
                    return "titlePosition";
                }

                public CssMetaData<? extends Styleable, HPos> getCssMetaData() {
                    return StyleableProperties.TITLE_POSITION;
                }
            };
        }
        return this.titlePosition;
    }

    public final void setTitlePosition(HPos value) {
        this.titlePositionProperty().set((Object)value);
    }

    public final HPos getTitlePosition() {
        return this.titlePosition == null ? HPos.LEFT : (HPos)this.titlePosition.get();
    }

    private void init() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.leftCorner = new StackPane();
        this.leftCorner.getStyleClass().add((Object)"left-corner");
        this.rightCorner = new StackPane();
        this.rightCorner.getStyleClass().add((Object)"right-corner");
        this.border = new StackPane();
        this.border.getStyleClass().add((Object)"content-area");
        this.titleLabel.getStyleClass().add((Object)"title-area");
        this.getChildren().addAll((Object[])new Node[]{this.leftCorner, this.rightCorner, this.border, this.titleLabel});
        this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    List added = c.getAddedSubList();
                    for (Node n : added) {
                        if (!(n instanceof Pane) || n.getStyleClass().contains((Object)"grid")) continue;
                        n.getStyleClass().add((Object)FieldSetLayout.PADDING_8);
                    }
                }
            }
        });
    }

    private double computeLeftWidth(double width, double titleWidth) {
        HPos titlePos = this.getTitlePosition();
        double edgeDist = this.getEdgeDistance();
        double delta = width - titleWidth;
        double leftWidth = delta / 2.0;
        if (titlePos == HPos.LEFT) {
            leftWidth = edgeDist;
        } else if (titlePos == HPos.RIGHT) {
            leftWidth = delta - edgeDist;
        }
        return leftWidth;
    }

    private double computeRightWidth(double width, double titleWidth) {
        HPos titlePos = this.getTitlePosition();
        double edgeDist = this.getEdgeDistance();
        double delta = width - titleWidth;
        double rightWidth = delta / 2.0;
        if (titlePos == HPos.LEFT) {
            rightWidth = delta - edgeDist;
        } else if (titlePos == HPos.RIGHT) {
            rightWidth = edgeDist;
        }
        return rightWidth;
    }

    protected void layoutChildren() {
        double titleHalfHeight;
        List managed = this.getManagedChildren();
        managed.removeAll((Collection<?>)FXCollections.observableArrayList((Object[])new Region[]{this.titleLabel, this.rightCorner, this.leftCorner, this.border}));
        double top = this.getInsets().getTop();
        double right = this.getInsets().getRight();
        double bottom = this.getInsets().getBottom();
        double left = this.getInsets().getLeft();
        double width = this.getWidth() - left - right;
        double height = this.getHeight() - top - bottom;
        double titlePW = this.titleLabel.prefWidth(-1.0);
        double titlePH = this.titleLabel.prefHeight(-1.0);
        double leftHeight = titleHalfHeight = titlePH / 2.0;
        double rightHeight = titleHalfHeight;
        double leftWidth = this.computeLeftWidth(width, titlePW);
        double rightWidth = this.computeRightWidth(width, titlePW);
        this.leftCorner.resize(leftWidth, leftHeight);
        this.positionInArea((Node)this.leftCorner, 0.0, top + titleHalfHeight + this.leftCorner.getInsets().getTop(), leftWidth, leftHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.titleLabel.resize(titlePW, titlePH);
        this.positionInArea((Node)this.titleLabel, left + leftWidth, top, titlePW, titlePH, 0.0, HPos.CENTER, VPos.CENTER);
        this.rightCorner.resize(rightWidth, rightHeight);
        this.positionInArea((Node)this.rightCorner, left + leftWidth + titlePW + right, top + titleHalfHeight + this.rightCorner.getInsets().getTop(), rightWidth, rightHeight, 0.0, HPos.CENTER, VPos.CENTER);
        this.border.resize(this.getWidth(), height - titleHalfHeight);
        this.positionInArea((Node)this.border, 0.0, top + titlePH, this.getWidth(), height - titleHalfHeight, 0.0, HPos.CENTER, VPos.CENTER);
        for (Node child : managed) {
            this.layoutInArea(child, left, top + titlePH + titleHalfHeight, width, height - titlePH - titleHalfHeight, 0.0, HPos.CENTER, VPos.CENTER);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLE_PROPERTY_LIST;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FieldSetLayout.getClassCssMetaData();
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    private static class StyleableProperties {
        private static final CssMetaData<FieldSetLayout, HPos> TITLE_POSITION = new CssMetaData<FieldSetLayout, HPos>("-fx-title-position", (StyleConverter)new EnumConverter(HPos.class), HPos.LEFT){

            public boolean isSettable(FieldSetLayout fieldSet) {
                return fieldSet.titlePosition == null || !fieldSet.titlePosition.isBound();
            }

            public StyleableProperty<HPos> getStyleableProperty(FieldSetLayout fsl) {
                return (StyleableObjectProperty)fsl.titlePositionProperty();
            }
        };
        private static final CssMetaData<FieldSetLayout, Number> EDGE_DISTANCE = new CssMetaData<FieldSetLayout, Number>("-fx-edge-distance", SizeConverter.getInstance(), (Number)20.0){

            public boolean isSettable(FieldSetLayout fieldSet) {
                return fieldSet.edgeDistance == null || !fieldSet.edgeDistance.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(FieldSetLayout styleable) {
                return (StyleableDoubleProperty)styleable.edgeDistanceProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLE_PROPERTY_LIST;

        private StyleableProperties() {
        }

        static {
            ArrayList list = new ArrayList(StackPane.getClassCssMetaData());
            Collections.addAll(list, TITLE_POSITION, EDGE_DISTANCE);
            STYLEABLE_PROPERTY_LIST = Collections.unmodifiableList(list);
        }
    }
}

