/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.ImageUtils;
import com.anahata.jfx.config.JavaFXConfig;
import com.anahata.util.cdi.Cdi;
import com.anahata.util.model.Activatable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityTreeItem<T>
extends TreeItem<String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityTreeItem.class);
    private JavaFXConfig config;
    private Image deleteIcon;
    private ObjectProperty<T> entity = new SimpleObjectProperty();
    private BooleanProperty showDeletedChildren = new SimpleBooleanProperty(false);
    private ObjectProperty<Predicate> filter = new SimpleObjectProperty();
    private List<AbstractEntityTreeItem> allChildren = new ArrayList<AbstractEntityTreeItem>();

    public T getEntity() {
        return (T)this.entity.getValue();
    }

    public void setEntity(T entity) {
        log.trace("{} updating entity to: {}", (Object)this.getDisplayName(), entity);
        this.entity.setValue(entity);
    }

    public ObjectProperty<T> entityProperty() {
        return this.entity;
    }

    public final BooleanProperty showDeletedChildrenProperty() {
        return this.showDeletedChildren;
    }

    public final Boolean isShowDeletedChildren() {
        return this.showDeletedChildrenProperty().get();
    }

    public final void setShowDeletedChildren(boolean showDeletedChildren) {
        this.showDeletedChildrenProperty().set(showDeletedChildren);
    }

    public Predicate getFilter() {
        return (Predicate)this.filter.getValue();
    }

    public void setFilter(Predicate filter) {
        this.filter.setValue((Object)filter);
    }

    public ObjectProperty<Predicate> filterProperty() {
        return this.filter;
    }

    protected AbstractEntityTreeItem(T entity) {
        this.config = (JavaFXConfig)Cdi.get(JavaFXConfig.class, (Annotation[])new Annotation[0]);
        this.deleteIcon = new Image(this.config.getDeleteIcon());
        this.entity.addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                AbstractEntityTreeItem.this.updateDisplay(false);
            }
        });
        this.entity.setValue(entity);
        this.showDeletedChildrenProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                AbstractEntityTreeItem.this.updateDisplay(false);
            }
        });
    }

    public final void refresh() {
        this.getChildren().setAll(this.computeDisplayedChildren());
        ObservableList children = this.getChildren();
        for (AbstractEntityTreeItem child : children) {
            child.refresh();
        }
    }

    public final boolean isActive() {
        return this.isActiveImpl();
    }

    public final List<AbstractEntityTreeItem> getPathToRoot() {
        ArrayList<AbstractEntityTreeItem> ret = new ArrayList<AbstractEntityTreeItem>();
        ret.add(this);
        for (TreeItem parent = super.getParent(); parent != null; parent = parent.getParent()) {
            ret.add((AbstractEntityTreeItem)parent);
        }
        return ret;
    }

    public final AbstractEntityTreeItem expandPathToEntity(Object entity) {
        AbstractEntityTreeItem ti = this.findTreeItemForEntity(entity);
        if (ti != null) {
            ti.setExpanded(true);
            for (TreeItem parent = ti.getParent(); parent != null; parent = parent.getParent()) {
                parent.setExpanded(true);
            }
        }
        return ti;
    }

    public final AbstractEntityTreeItem findTreeItemForEntity(Object entity) {
        if (Objects.equals(entity, this.getEntity())) {
            return this;
        }
        if (!this.isLeaf()) {
            for (Object o : this.getChildren()) {
                AbstractEntityTreeItem casted;
                AbstractEntityTreeItem ret;
                if (!(o instanceof AbstractEntityTreeItem) || (ret = (casted = (AbstractEntityTreeItem)((Object)o)).findTreeItemForEntity(entity)) == null) continue;
                return ret;
            }
        }
        return null;
    }

    public final Node makeGraphic() {
        if (this.isActive()) {
            return this.getBaseGraphic();
        }
        Group overlay = ImageUtils.getOverLayedImage(this.getBaseGraphic(), this.deleteIcon, 16, 0, true, Pos.BOTTOM_RIGHT);
        return overlay;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " value=" + (String)this.getValue() + " active=" + this.isActive() + " identityHashCode=" + System.identityHashCode((Object)this);
    }

    private static AbstractEntityTreeItem findItemForEntity(List<AbstractEntityTreeItem> items, Object entity) {
        for (AbstractEntityTreeItem item : items) {
            if (!Objects.equals(item.getEntity(), entity)) continue;
            return item;
        }
        return null;
    }

    private List<AbstractEntityTreeItem> computeDisplayedChildren() {
        List<AbstractEntityTreeItem> items = this.isShowDeletedChildren() != false ? this.allChildren : this.computeActiveChildren();
        Predicate predicate = (Predicate)this.filter.getValue();
        if (predicate == null) {
            return items;
        }
        ArrayList<AbstractEntityTreeItem> filtered = new ArrayList<AbstractEntityTreeItem>();
        for (AbstractEntityTreeItem item : items) {
            if (!predicate.evaluate(item.getEntity())) continue;
            filtered.add(item);
        }
        return filtered;
    }

    private List<AbstractEntityTreeItem> computeActiveChildren() {
        ArrayList<AbstractEntityTreeItem> ret = new ArrayList<AbstractEntityTreeItem>();
        for (AbstractEntityTreeItem child : this.allChildren) {
            if (!child.isActive()) continue;
            ret.add(child);
        }
        return ret;
    }

    public final void updateDisplay(boolean forceRecursive) {
        List<AbstractEntityTreeItem> newDisplayedChildren;
        super.setValue((Object)this.getDisplayName());
        super.setGraphic(this.makeGraphic());
        List latestChildEntities = this.getChildrenEntities();
        if (log.isTraceEnabled()) {
            log.trace("Updating display for {}, showDeleted={} displayedChildrenEntities={} latestChildEntities={}", new Object[]{this.getDisplayName(), this.showDeletedChildren.get(), this.getDisplayedChildrenEntities(), latestChildEntities});
        }
        AbstractEntityTreeItem[] newAllChildrenArr = new AbstractEntityTreeItem[latestChildEntities.size()];
        for (int idx = 0; idx < latestChildEntities.size(); ++idx) {
            AbstractEntityTreeItem childTreeItem;
            Object child = latestChildEntities.get(idx);
            AbstractEntityTreeItem currentEquivalent = AbstractEntityTreeItem.findItemForEntity(this.allChildren, child);
            if (currentEquivalent != null) {
                newAllChildrenArr[idx] = currentEquivalent;
                T currentEquivalentsEntity = currentEquivalent.getEntity();
                currentEquivalent.setEntity(child);
                if (Objects.equals(currentEquivalentsEntity, child) && forceRecursive) {
                    currentEquivalent.updateDisplay(forceRecursive);
                    continue;
                }
                if (!forceRecursive || !log.isTraceEnabled()) continue;
                log.trace("{} Not calling updateDisplay on child {} with forceRecursive = true as new and old wrapped entities are not equals. old={}, new={}", new Object[]{this.getDisplayName(), currentEquivalent.getDisplayName(), currentEquivalentsEntity, child});
                continue;
            }
            newAllChildrenArr[idx] = childTreeItem = this.wrapChildEntity(child);
            newAllChildrenArr[idx].showDeletedChildren.bind((ObservableValue)this.showDeletedChildren);
            newAllChildrenArr[idx].filter.bind(this.filter);
        }
        List<AbstractEntityTreeItem> newAllChildrenList = Arrays.asList(newAllChildrenArr);
        for (AbstractEntityTreeItem oldChild : this.allChildren) {
            if (newAllChildrenList.contains((Object)oldChild)) continue;
            oldChild.showDeletedChildren.unbind();
            oldChild.filter.unbind();
        }
        this.allChildren = newAllChildrenList;
        ObservableList currentDisplayedChildren = this.getChildren();
        if (!CollectionUtils.isEqualCollection((Collection)currentDisplayedChildren, newDisplayedChildren = this.computeDisplayedChildren())) {
            currentDisplayedChildren.setAll(newDisplayedChildren);
        }
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    protected boolean isActiveImpl() {
        if (this.entity.getValue() instanceof Activatable) {
            return ((Activatable)this.entity.getValue()).isActive();
        }
        return true;
    }

    public Object getParentEntity() {
        return this.getParentEntityTreeItem().getEntity();
    }

    public AbstractEntityTreeItem getParentEntityTreeItem() {
        return (AbstractEntityTreeItem)this.getParent();
    }

    public List getDisplayedChildrenEntities() {
        ObservableList current = super.getChildren();
        ArrayList<T> ret = new ArrayList<T>(current.size());
        for (AbstractEntityTreeItem abstractEntityTreeItem : current) {
            ret.add(abstractEntityTreeItem.getEntity());
        }
        return ret;
    }

    protected abstract String getDisplayName();

    protected abstract Node getBaseGraphic();

    protected abstract List getChildrenEntities();

    protected abstract AbstractEntityTreeItem wrapChildEntity(Object var1);

    public void setExpandedAll(boolean expanded) {
        this.setExpanded(expanded);
        for (TreeItem ti : this.getChildren()) {
            if (!(ti instanceof AbstractEntityTreeItem)) continue;
            ((AbstractEntityTreeItem)ti).setExpandedAll(expanded);
        }
    }

    public List<AbstractEntityTreeItem> getAllChildAbstractEntityTreeItems() {
        ArrayList<AbstractEntityTreeItem> all = new ArrayList<AbstractEntityTreeItem>();
        for (TreeItem ti : this.getChildren()) {
            if (!(ti instanceof AbstractEntityTreeItem)) continue;
            AbstractEntityTreeItem aeti = (AbstractEntityTreeItem)ti;
            all.add(aeti);
            all.addAll(aeti.getAllChildAbstractEntityTreeItems());
        }
        return all;
    }
}

