/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.internal.scene.control.skin;

import com.anahata.jfx.internal.scene.control.behavior.AutoCompleteTextFieldBehavior;
import com.anahata.jfx.scene.control.AutoCompleteTextField;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompleteTextFieldSkin<T>
extends BehaviorSkinBase<AutoCompleteTextField<T>, AutoCompleteTextFieldBehavior<T>> {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteTextFieldSkin.class);
    private final ListView<T> listView = new ListView();
    private final AnchorPane image = new AnchorPane();
    private final TextField textField = new TextField();
    private Popup popup = new Popup();
    private final Timeline showImageTimeline = new Timeline();
    private T itemToShowInImage;

    public AutoCompleteTextFieldSkin(AutoCompleteTextField<T> control) {
        super(control, new AutoCompleteTextFieldBehavior<T>(control));
        this.initialize();
    }

    private void initialize() {
        final AutoCompleteTextField control = (AutoCompleteTextField)this.getSkinnable();
        control.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                Platform.runLater(() -> this.textField.requestFocus());
            }
        });
        control.setAlignment(this.textField.getAlignment());
        control.textFieldFocusedProperty().bind((ObservableValue)this.textField.focusedProperty());
        control.editorTextProperty().bindBidirectional((Property)this.textField.textProperty());
        this.textField.promptTextProperty().bind((ObservableValue)control.promptTextProperty());
        this.textField.alignmentProperty().bind(control.alignmentProperty());
        this.textField.prefColumnCountProperty().bind((ObservableValue)control.prefColumnCountProperty());
        this.textField.focusTraversableProperty().bind((ObservableValue)control.focusTraversableProperty());
        ((AutoCompleteTextFieldBehavior)this.getBehavior()).initialize(this);
        this.listView.setCellFactory(new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> p) {
                ListCell cell = new ListCell<T>(){
                    {
                        super.setOnMouseExited(event -> {
                            AutoCompleteTextFieldSkin.this.showImageTimeline.stop();
                            AutoCompleteTextFieldSkin.this.showImage(this.getListView().getSelectionModel().getSelectedItem());
                        });
                    }

                    public void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        if (item != null) {
                            AutoCompleteTextField.DataFormatter df = control.getDataFormatter();
                            this.setText(control.getDataFormatter().toListViewString(item));
                            if (df instanceof AutoCompleteTextField.GraphicDataFormatter) {
                                AutoCompleteTextField.GraphicDataFormatter gdf = (AutoCompleteTextField.GraphicDataFormatter)df;
                                this.setGraphic(gdf.getListViewGraphic(item));
                                this.setPrefHeight(gdf.getCellHeight());
                            }
                        } else {
                            this.setGraphic(null);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
        this.textField.focusedProperty().addListener((observable, oldValue, newValue) -> this.textField.end());
        this.popup = new Popup();
        this.popup.setAutoHide(true);
        HBox popupContent = new HBox();
        popupContent.setFillHeight(false);
        popupContent.setSpacing(5.0);
        popupContent.setAlignment(Pos.TOP_LEFT);
        popupContent.getChildren().add(this.listView);
        popupContent.getChildren().add((Object)this.image);
        this.popup.getContent().add((Object)popupContent);
        popupContent.prefHeightProperty().bind((ObservableValue)this.listView.prefHeightProperty().add(15));
        this.getChildren().addAll((Object[])new Node[]{this.textField});
        this.listView.getFocusModel().focusedItemProperty().addListener((observable, oldValue, newValue) -> this.showImage(newValue));
        this.showImageTimeline.getKeyFrames().add((Object)new KeyFrame(new Duration(500.0), event -> {
            if (this.itemToShowInImage != null) {
                this.showImage(this.itemToShowInImage);
            }
        }, new KeyValue[0]));
    }

    public void showPopup() {
        int itemsCount = this.listView.getItems().size();
        if (itemsCount == 0) {
            return;
        }
        IntegerBinding itemsCountProperty = Bindings.size((ObservableList)this.listView.getItems());
        AutoCompleteTextField.GraphicDataFormatter gdf = ((AutoCompleteTextField)this.getSkinnable()).getGraphicDataFormatter();
        int cellHeight = gdf != null ? gdf.getCellHeight() : 24;
        NumberBinding itemsToShow = Bindings.min((ObservableNumberValue)itemsCountProperty, (ObservableNumberValue)((AutoCompleteTextField)this.getSkinnable()).popupSize());
        this.listView.prefHeightProperty().bind((ObservableValue)itemsToShow.multiply(cellHeight).add(15));
        this.listView.scrollTo(0);
        Scene scene = ((AutoCompleteTextField)this.getSkinnable()).getScene();
        if (scene != null) {
            Window window = scene.getWindow();
            int prefListWidth = ((AutoCompleteTextField)this.getSkinnable()).getPrefListWidth();
            if (prefListWidth == 0) {
                this.listView.setPrefWidth(this.textField.getWidth());
            } else {
                this.listView.setPrefWidth((double)prefListWidth);
            }
            this.listView.getSelectionModel().clearSelection();
            this.listView.getFocusModel().focus(-1);
            Point2D fieldPosition = this.textField.localToScene(0.0, 0.0);
            double anchorY = window.getY() + fieldPosition.getY() + scene.getY() + this.textField.getHeight();
            if (anchorY + this.listView.getPrefHeight() > window.getHeight()) {
                anchorY = anchorY - this.listView.getPrefHeight() - this.textField.getHeight();
            }
            this.popup.show(window, window.getX() + fieldPosition.getX() + scene.getX(), anchorY);
        }
    }

    public void hidePopup() {
        this.popup.hide();
    }

    public boolean isPopupShowing() {
        return this.popup.isShowing();
    }

    public TextField getTextField() {
        return this.textField;
    }

    public ListView<T> getListView() {
        return this.listView;
    }

    private void showImage(T newValue) {
        AutoCompleteTextField.DataFormatter df = ((AutoCompleteTextField)this.getSkinnable()).getDataFormatter();
        if (df instanceof AutoCompleteTextField.GraphicDataFormatter) {
            AutoCompleteTextField.GraphicDataFormatter gdf = (AutoCompleteTextField.GraphicDataFormatter)df;
            Node graphic = gdf.toImageGraphic(newValue);
            if (graphic != null) {
                this.image.getChildren().setAll((Object[])new Node[]{graphic});
            } else {
                this.image.getChildren().clear();
            }
        }
    }
}

