/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import com.anahata.jfx.JfxUtils;
import com.anahata.jfx.ReadOnlyUtils;
import com.anahata.jfx.bind.Bind;
import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.BindListener;
import com.anahata.jfx.bind.BindModel;
import com.anahata.jfx.bind.BindReadOnly;
import com.anahata.jfx.bind.BindReadOnlyModel;
import com.anahata.jfx.bind.BindRevert;
import com.anahata.jfx.bind.BindSave;
import com.anahata.jfx.bind.BindSubView;
import com.anahata.jfx.bind.BindUtils;
import com.anahata.jfx.bind.BindView;
import com.anahata.jfx.bind.Binding;
import com.anahata.jfx.bind.TargetBean;
import com.anahata.jfx.bind.Validations;
import com.anahata.jfx.bind.ValidationsImpl;
import com.anahata.jfx.bind.View;
import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.filter.KeystrokeFilter;
import com.anahata.jfx.bind.table.BindTable;
import com.anahata.jfx.bind.table.BindingTableView;
import com.anahata.jfx.binding.BooleanArrayBinding;
import com.anahata.jfx.config.JavaFXConfig;
import com.anahata.jfx.message.JfxMessages;
import com.anahata.util.metamodel.MetaModelProperty;
import com.anahata.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.validation.Validator;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class Binder
implements BindForm {
    private static final Logger log = LoggerFactory.getLogger(Binder.class);
    @Inject
    private JfxMessages jfxMessages;
    @Inject
    private Validator validator;
    @Inject
    private JavaFXConfig config;
    private Object controller;
    private List<Field> controllerFields;
    private final Map<String, TargetBean> targetBeans = new HashMap<String, TargetBean>();
    private final List<Binding> bindings = new ArrayList<Binding>(40);
    private Map<Object, Binding> bindingsByNode;
    private final Map<String, List<Binding>> bindingsById = new HashMap<String, List<Binding>>();
    private final BooleanProperty formValid = new SimpleBooleanProperty(true);
    private final BooleanProperty thisFormValid = new SimpleBooleanProperty(true);
    private final BooleanProperty globalValid = new SimpleBooleanProperty(true);
    private final BooleanProperty formModified = new SimpleBooleanProperty(false);
    private final BooleanProperty thisFormModified = new SimpleBooleanProperty(false);
    private final SetProperty<String> invalidProperties = new SimpleSetProperty(FXCollections.observableSet(new HashSet()));
    private final ObjectProperty<BindingPhase> bindingPhase = new SimpleObjectProperty((Object)BindingPhase.INIT);
    private final List<BindForm> bindForms = new ArrayList<BindForm>();
    private boolean block;
    private BindForm parentBindForm;
    private Binding parentBinding;
    private Validations validations;
    private final BooleanProperty containerErrors = new SimpleBooleanProperty(false);
    private View view;
    private final Map<Binding, View> bindingViews = new HashMap<Binding, View>();
    private final Map<Pane, View> subViews = new HashMap<Pane, View>();
    private Binder rootBinder;
    private Node focusedField;
    private List<BindListener> listeners = new ArrayList<BindListener>();

    public Binder() {
        this.thisFormValid.bind((ObservableValue)this.invalidProperties.emptyProperty());
    }

    public void init(Object controller) {
        Validate.notNull((Object)controller);
        log.debug("init: ENTRY controller={}", (Object)controller.getClass().getSimpleName());
        this.rootBinder = this;
        this.controller = controller;
        this.controllerFields = ReflectionUtils.getAllDeclaredFields(controller.getClass());
        ObservableValue readOnly = null;
        ArrayList<Node> readOnlyNodes = new ArrayList<Node>();
        ArrayList<TableView> readOnlyTables = new ArrayList<TableView>();
        for (Field field : this.controllerFields) {
            BindReadOnlyModel bindReadOnlyModel;
            BindReadOnly bindReadOnly;
            BindView bindView;
            BindModel bindModel = field.getAnnotation(BindModel.class);
            if (bindModel != null) {
                Validate.validState((boolean)ObjectProperty.class.isAssignableFrom(field.getType()), (String)"@BindModel field %s is not an ObjectProperty", (Object[])new Object[]{field.getName()});
                ObjectProperty targetBean = (ObjectProperty)ReflectionUtils.readField((Object)controller, ObjectProperty.class, (Field)field);
                Validate.validState((targetBean != null ? 1 : 0) != 0, (String)"@BindModel field %s is null", (Object[])new Object[]{field.getName()});
                Validate.validState((!this.targetBeans.containsKey(bindModel.id()) ? 1 : 0) != 0, (String)"A @BindModel with id %s has already been defined, field %s.%s is invalid", (Object[])new Object[]{bindModel.id(), controller.getClass().getSimpleName(), field.getName()});
                this.targetBeans.put(bindModel.id(), new TargetBean(this.validator, bindModel.id(), targetBean, bindModel.autoBind()));
            }
            if ((bindView = field.getAnnotation(BindView.class)) != null) {
                Validate.validState((boolean)Pane.class.isAssignableFrom(field.getType()), (String)"@BindView field %s is not a Pane", (Object[])new Object[]{field.getName()});
                Pane pane = (Pane)ReflectionUtils.readField((Object)controller, Pane.class, (Field)field);
                Validate.validState((pane != null ? 1 : 0) != 0, (String)"@BindView field %s is null", (Object[])new Object[]{field.getName()});
                Validate.validState((this.view == null ? 1 : 0) != 0, (String)"A @BindView has already been defined, use @BindSubView for child views; node={}", (Object[])new Object[]{pane});
                log.debug("Registering view with pane: {}", (Object)pane);
                this.view = new View(pane);
            }
            if ((bindReadOnly = field.getAnnotation(BindReadOnly.class)) != null) {
                Validate.validState((boolean)Node.class.isAssignableFrom(field.getType()), (String)"@BindReadOnly field %s is not a Node", (Object[])new Object[]{field.getName()});
                Node node = (Node)ReflectionUtils.readField((Object)controller, Node.class, (Field)field);
                Validate.validState((node != null ? 1 : 0) != 0, (String)"@BindReadOnly field %s is null", (Object[])new Object[]{field.getName()});
                if (TableView.class.isAssignableFrom(field.getType())) {
                    readOnlyTables.add((TableView)node);
                } else {
                    readOnlyNodes.add(node);
                }
            }
            if ((bindReadOnlyModel = field.getAnnotation(BindReadOnlyModel.class)) == null) continue;
            Validate.validState((boolean)ObservableValue.class.isAssignableFrom(field.getType()), (String)"@BindReadOnlyModel field %s is not an ObservableValue<Boolean>", (Object[])new Object[]{field.getName()});
            Validate.validState((readOnly == null ? 1 : 0) != 0, (String)"A @BindReadOnlyModel has been defined twice, second one is for field %s", (Object[])new Object[]{field.getName()});
            readOnly = (ObservableValue)ReflectionUtils.readField((Object)controller, ObservableValue.class, (Field)field);
        }
        Validate.validState((!this.targetBeans.isEmpty() ? 1 : 0) != 0, (String)"At least one target bean is required", (Object[])new Object[0]);
        for (Field field : this.controllerFields) {
            BindRevert bindDiscard;
            TargetBean targetBean;
            Class declaringClass;
            MetaModelProperty[] mmFields;
            Bind bind = field.getAnnotation(Bind.class);
            BindTable bindTable = field.getAnnotation(BindTable.class);
            Validate.validState((bind == null || bindTable == null ? 1 : 0) != 0, (String)"Both @Bind and @BindTable cannot be declared on the same property: %s", (Object[])new Object[]{field.getName()});
            if (bind != null) {
                Validate.validState((!TableView.class.isAssignableFrom(field.getType()) ? 1 : 0) != 0, (String)"Property for @Bind cannot be a TableView: %s", (Object[])new Object[]{field.getName()});
                Validate.validState((bind.property() != null && bind.property().length >= 1 ? 1 : 0) != 0, (String)"At least one property must be defined for @Bind", (Object[])new Object[0]);
                mmFields = new MetaModelProperty[bind.property().length];
                for (int j = 0; j < bind.property().length; ++j) {
                    mmFields[j] = (MetaModelProperty)ReflectionUtils.getInstance(bind.property()[j], (Object[])new Object[0]);
                }
                declaringClass = mmFields[0].getDeclaringClass();
                targetBean = this.targetBeans.get(bind.id());
                Validate.notNull((Object)targetBean, (String)"Could not find bean for class %s while initialsing controller %s", (Object[])new Object[]{declaringClass.getName(), controller});
                if (targetBean != null) {
                    Converter converter;
                    Class<? extends Converter> converterClass = bind.converter();
                    try {
                        converter = (Converter)ReflectionUtils.getInstanceIfNotBase(Converter.class, converterClass, (Object[])new Object[0]);
                    }
                    catch (Exception e) {
                        converter = (Converter)ReflectionUtils.getInstanceIfNotBase(Converter.class, converterClass, (Object[])new Object[]{controller});
                    }
                    Class<? extends KeystrokeFilter> filterClass = bind.keystrokeFilter();
                    KeystrokeFilter filter = (KeystrokeFilter)ReflectionUtils.getInstanceIfNotBase(KeystrokeFilter.class, filterClass, (Object[])new Object[0]);
                    Object node = ReflectionUtils.readField((Object)controller, Object.class, (Field)field);
                    Class[] args = ReflectionUtils.getGenericArgs((Field)field);
                    Binding binding = new Binding(this, this.validator, node, args == null ? null : args[0], targetBean, mmFields, converter, filter, this.jfxMessages, bind.readOnly(), bind.id());
                    this.bindings.add(binding);
                    List<Binding> idBindings = this.bindingsById.get(bind.id());
                    if (idBindings == null) {
                        idBindings = new ArrayList<Binding>();
                        this.bindingsById.put(bind.id(), idBindings);
                    }
                    idBindings.add(binding);
                    if (BindForm.class.isAssignableFrom(field.getType())) {
                        BindForm bindForm = (BindForm)node;
                        log.debug("Found BindForm {}, setting parent bind form as {}", (Object)field, (Object)this.getBestParentBindForm());
                        bindForm.setParentBindForm(this);
                        bindForm.setParentBinding(binding);
                        bindForm.setRootBinder(this.rootBinder);
                        this.bindForms.add(bindForm);
                    }
                }
            } else if (bindTable != null) {
                Validate.validState((boolean)TableView.class.isAssignableFrom(field.getType()), (String)"Property for @BindTable must be a TableView: %s", (Object[])new Object[]{field.getName()});
                Validate.validState((bindTable.property() != null && bindTable.property().length >= 1 ? 1 : 0) != 0, (String)"At least one property must be defined for @BindTable", (Object[])new Object[0]);
                mmFields = new MetaModelProperty[bindTable.property().length];
                for (int j = 0; j < bindTable.property().length; ++j) {
                    mmFields[j] = (MetaModelProperty)ReflectionUtils.getInstance(bindTable.property()[j], (Object[])new Object[0]);
                }
                declaringClass = mmFields[0].getDeclaringClass();
                targetBean = this.targetBeans.get(bindTable.id());
                TableView tableView = (TableView)ReflectionUtils.readField((Object)controller, TableView.class, (Field)field);
                Validate.notNull((Object)targetBean, (String)"Could not find bean for class %s while initialsing controller %s", (Object[])new Object[]{declaringClass.getName(), controller});
                BindingTableView bindingTableView = new BindingTableView(tableView, bindTable.tableRow());
                bindingTableView.setParentBindForm(this);
                this.bindForms.add(bindingTableView);
                Binding binding = new Binding(this, this.validator, tableView, null, targetBean, mmFields, null, null, this.jfxMessages, true, bindTable.id());
                bindingTableView.setParentBinding(binding);
                bindingTableView.setRootBinder(this.rootBinder);
                this.bindings.add(binding);
                List<Binding> idBindings = this.bindingsById.get(bindTable.id());
                if (idBindings == null) {
                    idBindings = new ArrayList<Binding>();
                    this.bindingsById.put(bindTable.id(), idBindings);
                }
                idBindings.add(binding);
            }
            this.refreshBindFormBindings();
            BindSave bindSave = field.getAnnotation(BindSave.class);
            if (bindSave != null) {
                Button button = (Button)ReflectionUtils.readField((Object)controller, Button.class, (Field)field);
                JfxUtils.bindStyleClass((Node)button, (ObservableValue<? extends Boolean>)this.formValid, null, "jfxBindSaveInvalid");
                button.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<Event>(){

                    public void handle(Event event) {
                        if (!Binder.this.formValid.get()) {
                            Binder.this.validate(true, new Object[0]);
                            event.consume();
                        }
                    }
                });
            }
            if ((bindDiscard = field.getAnnotation(BindRevert.class)) == null) continue;
            Button button = (Button)ReflectionUtils.readField((Object)controller, Button.class, (Field)field);
            button.disableProperty().bind((ObservableValue)this.formModified.not());
        }
        for (final TargetBean targetBean : this.targetBeans.values()) {
            if (!targetBean.isAutoBind()) continue;
            targetBean.getBean().addListener(new InvalidationListener(){

                public void invalidated(Observable o) {
                    List bindingsList = (List)Binder.this.bindingsById.get(targetBean.getId());
                    if (bindingsList != null) {
                        Binder.this.bindFromModelList(bindingsList);
                    }
                }
            });
        }
        this.bindingsByNode = new HashMap<Object, Binding>(this.bindings.size());
        for (Binding binding : this.bindings) {
            this.bindingsByNode.put(binding.getNode(), binding);
        }
        this.validations = new ValidationsImpl(this.rootBinder, this.bindForms);
        this.bindingPhase.set((Object)BindingPhase.USER_INPUT);
        for (Field field : this.controllerFields) {
            BindSubView bindSubView = field.getAnnotation(BindSubView.class);
            if (bindSubView == null) continue;
            Validate.validState((boolean)Pane.class.isAssignableFrom(field.getType()), (String)"@BindSubView field %s is not a Pane", (Object[])new Object[]{field.getName()});
            Pane pane = (Pane)ReflectionUtils.readField((Object)controller, Pane.class, (Field)field);
            Validate.validState((pane != null ? 1 : 0) != 0, (String)"@BindSubView field %s is null", (Object[])new Object[]{field.getName()});
            View subView = new View(pane);
            this.subViews.put(pane, subView);
        }
        if (readOnly != null) {
            log.debug("init: Have a read only model, processing read only nodes");
            ReadOnlyUtils.bindReadOnlyList((ObservableValue<? extends Boolean>)readOnly, readOnlyNodes);
            ReadOnlyUtils.bindReadOnlyList((ObservableValue<? extends Boolean>)readOnly, readOnlyTables);
        }
        log.debug("init: RETURN, controller={}", (Object)controller.getClass().getSimpleName());
    }

    public void addListener(@NonNull BindListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.listeners.add(listener);
    }

    @Override
    public void bindFromModel() {
        this.bindFromModel(true);
    }

    public void bindFromModel(boolean clearMessages) {
        this.bindingPhase.set((Object)BindingPhase.BIND_FROM_MODEL);
        this.setValidationRequired();
        if (clearMessages) {
            for (Binding binding : this.bindings) {
                binding.clearMessages();
            }
        }
        this.globalValid.set(true);
        this.invalidProperties.clear();
        this.getRootBinder().preBindFromModel();
        for (Binding binding : this.bindings) {
            binding.bindFromModel(new Object[0]);
        }
        this.validate(false, new Object[0]);
        this.refreshSubViewValid();
        this.bindingPhase.set((Object)BindingPhase.USER_INPUT);
    }

    public void bindFromModel(Object ... nodes) {
        Validate.notNull((Object)nodes);
        this.bindingPhase.set((Object)BindingPhase.BIND_FROM_MODEL);
        this.globalValid.set(true);
        this.setValidationRequired();
        this.getRootBinder().preBindFromModel();
        for (Object node : nodes) {
            Binding binding = this.bindingsByNode.get(node);
            if (binding == null) continue;
            binding.bindFromModel(new Object[0]);
        }
        this.validate(false, new Object[0]);
        this.bindingPhase.set((Object)BindingPhase.USER_INPUT);
    }

    private void bindFromModelList(List<Binding> bindingList) {
        this.bindingPhase.set((Object)BindingPhase.BIND_FROM_MODEL);
        this.globalValid.set(true);
        this.setValidationRequired();
        this.getRootBinder().preBindFromModel();
        for (Binding binding : bindingList) {
            binding.bindFromModel(new Object[0]);
        }
        this.validate(false, new Object[0]);
        this.bindingPhase.set((Object)BindingPhase.USER_INPUT);
    }

    @Override
    public BooleanProperty formValidProperty() {
        return this.formValid;
    }

    @Override
    public BooleanProperty formModifiedProperty() {
        return this.formModified;
    }

    @Override
    public Map<Node, Binding> getAllNodeBindings() {
        HashMap<Node, Binding> nodes = new HashMap<Node, Binding>();
        for (Binding binding : this.bindings) {
            if (!(binding.getNode() instanceof Node)) continue;
            nodes.put((Node)binding.getNode(), binding);
        }
        for (BindForm bindForm : this.bindForms) {
            nodes.putAll(bindForm.getAllNodeBindings());
        }
        return nodes;
    }

    public BooleanProperty getValidProperty(Object node) {
        Binding binding = this.bindingsByNode.get(node);
        return binding != null ? binding.validProperty() : null;
    }

    public BooleanProperty getInContextProperty(Object node) {
        Binding binding = this.bindingsByNode.get(node);
        return binding != null ? binding.inContextProperty() : null;
    }

    public BooleanProperty getActiveOnlyProperty(Object node) {
        Binding binding = this.bindingsByNode.get(node);
        return binding != null ? binding.activeOnlyProperty() : null;
    }

    @Override
    public void validate(boolean publishError, Object ... excludeNodes) {
        Set<Object> excluded = BindUtils.getAllControllers(excludeNodes);
        for (Binding binding : this.bindings) {
            if (excluded.contains(binding.getNode())) continue;
            binding.validate(publishError);
        }
        for (BindForm bindForm : this.bindForms) {
            if (excluded.contains(bindForm)) continue;
            bindForm.validate(publishError, excludeNodes);
        }
    }

    @Override
    public void bindFromModelExcludingNode(Object node) {
        log.debug("bindFromModelExcludingNode node={}", node);
        Validate.notNull((Object)node);
        if (this.parentBindForm != null) {
            this.parentBindForm.bindFromModelExcludingNode(this.controller);
        } else {
            log.debug("Binder for controller {} doesn't have a parent bind form", this.controller);
        }
        Set<Object> excluded = BindUtils.getAllControllers(node);
        this.bindingPhase.set((Object)BindingPhase.BIND_FROM_MODEL);
        for (Binding binding : this.bindings) {
            if (excluded.contains(binding.getNode())) continue;
            binding.bindFromModel(node);
        }
        this.validate(false, node);
        this.bindingPhase.set((Object)BindingPhase.USER_INPUT);
    }

    @Override
    public BooleanProperty showContainerErrors() {
        return this.containerErrors;
    }

    @Override
    public void setExcludeNodes(Object ... nodes) {
    }

    @Override
    public void addValidationGroup(Class<?> validationGroup) {
        this.validations.addValidationGroup(validationGroup);
    }

    @Override
    public void removeValidationGroup(Class<?> validationGroup) {
        this.validations.removeValidationGroup(validationGroup);
    }

    @Override
    public BooleanProperty getValidationActive(Class<?> validationGroup) {
        return this.validations.getValidationActive(validationGroup);
    }

    @Override
    public ReadOnlyBooleanProperty getFormValidProperty(Class<?> validationGroup) {
        return this.validations.getFormValidProperty(validationGroup);
    }

    @Override
    public void setValid(String propertyName, Class<?> validationGroup) {
        this.validations.setValid(propertyName, validationGroup);
    }

    @Override
    public void setInvalid(String propertyName, Class<?> validationGroup) {
        this.validations.setInvalid(propertyName, validationGroup);
    }

    @Override
    public Set<Class<?>> getValidations() {
        return this.validations.getValidations();
    }

    public ReadOnlyObjectProperty<BindingPhase> bindingPhaseProperty() {
        return this.bindingPhase;
    }

    public BindingPhase getBindingPhase() {
        return (BindingPhase)((Object)this.bindingPhase.get());
    }

    @Override
    public View getView(Binding binding) {
        if (binding != null) {
            View bindingView = this.bindingViews.get(binding);
            if (bindingView != null) {
                return bindingView;
            }
            if (binding.getNode() instanceof Node) {
                Node node = (Node)binding.getNode();
                for (View subView : this.subViews.values()) {
                    if (!JfxUtils.isInAncestor(node, (Node)subView.getPane())) continue;
                    return subView;
                }
            }
        }
        if (this.view != null) {
            return this.view;
        }
        if (this.parentBindForm != null) {
            return this.parentBindForm.getView(binding);
        }
        throw new IllegalStateException("No View has been set on this binder: " + this);
    }

    @Override
    public void setView(View view, Binding binding) {
        if (binding == null) {
            this.view = view;
        } else {
            this.bindingViews.put(binding, view);
        }
    }

    public View getSubView(Pane pane) {
        Validate.notNull((Object)pane);
        return this.subViews.get(pane);
    }

    @Override
    public void resetFormModified() {
        this.thisFormModified.set(false);
        for (BindForm bindForm : this.bindForms) {
            bindForm.resetFormModified();
        }
    }

    public boolean isThisFormModified() {
        return this.thisFormModified.get();
    }

    public void setThisFormModified(boolean modified) {
        this.thisFormModified.set(modified);
    }

    public void addBindForm(BindForm bindForm) {
        Validate.notNull((Object)bindForm, (String)"A BindForm is required", (Object[])new Object[0]);
        bindForm.setParentBindForm(this);
        this.bindForms.add(bindForm);
        this.refreshBindFormBindings();
    }

    public <T extends BindForm> void addBindForms(List<T> bindForms) {
        Validate.notNull(bindForms, (String)"bindForms can not be null", (Object[])new Object[0]);
        for (BindForm bindForm : bindForms) {
            bindForm.setParentBindForm(this);
            this.bindForms.add(bindForm);
        }
        this.refreshBindFormBindings();
    }

    public <T extends BindForm> void removeBindForms(List<T> bindForms) {
        Validate.notNull(bindForms, (String)"bindForms can not be null", (Object[])new Object[0]);
        for (BindForm bindForm : bindForms) {
            Validate.isTrue((boolean)bindForms.contains(bindForm), (String)"The BindForm was not found: %s", (Object[])new Object[]{bindForm});
            bindForm.setParentBindForm(null);
        }
        this.bindForms.removeAll(bindForms);
        this.refreshBindFormBindings();
    }

    public void removeBindForm(BindForm bindForm) {
        Validate.notNull((Object)bindForm, (String)"A BindForm is required", (Object[])new Object[0]);
        bindForm.setParentBindForm(null);
        this.bindForms.remove(bindForm);
        this.refreshBindFormBindings();
    }

    public Object getTargetBean(String id) {
        Validate.notNull((Object)id);
        TargetBean tb = this.targetBeans.get(id);
        return tb == null ? null : tb.getBean().get();
    }

    public void focusLastEdited(boolean runLater) {
        JfxUtils.focusNicely(this.getRootBinder().getFocusedField(), runLater);
    }

    void setValid(String propertyName) {
        this.invalidProperties.remove((Object)propertyName);
    }

    void setInvalid(String propertyName) {
        this.invalidProperties.add((Object)propertyName);
    }

    void setGlobalValid() {
        this.globalValid.set(true);
    }

    void setGlobalInvalid() {
        this.globalValid.set(false);
    }

    void setFormModified(Binding binding) {
        if (this.bindingPhase.get() == BindingPhase.USER_INPUT) {
            this.thisFormModified.set(true);
        }
        this.bindFromModelExcludingBinding(binding);
        this.getBaseBinder().refreshSubViewValid();
    }

    @Override
    public void setValidationRequired() {
        log.trace("setValidationRequired");
        for (TargetBean tb : this.targetBeans.values()) {
            log.trace("setValidationRequired: Setting on target bean id={}", (Object)tb.getId());
            tb.setRequiresValidation(true);
        }
        for (BindForm bindForm : this.bindForms) {
            log.trace("setValidationRequired: Setting on BindForm {}", (Object)bindForm.getClass().getSimpleName());
            bindForm.setValidationRequired();
        }
    }

    private Binder getBaseBinder() {
        Binder current = this;
        for (BindForm parent = this.getParentBindForm(); parent != null; parent = parent.getParentBindForm()) {
            if (!(parent instanceof Binder)) continue;
            current = (Binder)parent;
        }
        Validate.validState((boolean)(current instanceof Binder), (String)"Could not find the base binder", (Object[])new Object[0]);
        return current;
    }

    private void refreshSubViewValid() {
        block0: for (View subView : this.subViews.values()) {
            List<Node> nodes = JfxUtils.getAllNodes((Parent)subView.getPane());
            Map<Node, Binding> binds = this.getAllNodeBindings();
            subView.setValid(true);
            for (Node node : nodes) {
                Binding binding = binds.get(node);
                if (binding == null || binding.getValid().get()) continue;
                subView.setValid(false);
                continue block0;
            }
        }
    }

    private void bindFromModelExcludingBinding(Binding excludeBinding) {
        log.debug("bindFromModelExcludingBinding: ENTRY excludeBinding.propertyName={}", (Object)(excludeBinding != null ? excludeBinding.getPropertyName() : "{null}"));
        if (this.parentBindForm != null) {
            this.parentBindForm.bindFromModelExcludingNode(this.controller);
        } else {
            log.debug("Binder for controller {} doesn't have a parent bind form", this.controller);
        }
        this.bindingPhase.set((Object)BindingPhase.BIND_FROM_MODEL);
        this.globalValid.set(true);
        for (Binding binding : this.bindings) {
            if (binding.equals(excludeBinding)) continue;
            binding.bindFromModel(new Object[0]);
        }
        this.validateExcludingBinding(false, excludeBinding);
        this.bindingPhase.set((Object)BindingPhase.USER_INPUT);
    }

    private void validateExcludingBinding(boolean publishError, Binding excludeBinding) {
        for (Binding binding : this.bindings) {
            if (excludeBinding.equals(binding)) continue;
            binding.validate(publishError);
        }
        for (BindForm bindForm : this.bindForms) {
            if (excludeBinding.getNode().equals(bindForm)) continue;
            bindForm.validate(publishError, new Object[0]);
        }
    }

    private void refreshBindFormBindings() {
        this.formValid.unbind();
        this.formModified.unbind();
        if (!this.bindForms.isEmpty()) {
            int bindFormsSize = this.bindForms.size();
            BooleanExpression[] validArray = new BooleanExpression[bindFormsSize];
            BooleanExpression[] modifiedArray = new BooleanExpression[bindFormsSize];
            for (int j = 0; j < bindFormsSize; ++j) {
                validArray[j] = this.bindForms.get(j).formValidProperty();
                modifiedArray[j] = this.bindForms.get(j).formModifiedProperty();
            }
            BooleanArrayBinding childValid = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.AND, validArray);
            BooleanArrayBinding childModified = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.OR, modifiedArray);
            this.formValid.bind((ObservableValue)childValid.and((ObservableBooleanValue)this.thisFormValid).and((ObservableBooleanValue)this.globalValid));
            this.formModified.bind((ObservableValue)childModified.or((ObservableBooleanValue)this.thisFormModified));
        } else {
            this.formValid.bind((ObservableValue)this.thisFormValid.and((ObservableBooleanValue)this.globalValid));
            this.formModified.bind((ObservableValue)this.thisFormModified);
        }
    }

    private void preBindFromModel() {
        for (BindListener listener : this.listeners) {
            listener.preBindFromModel();
        }
    }

    public BindForm getBestParentBindForm() {
        return this.controller instanceof BindForm ? (BindForm)this.controller : this.parentBindForm;
    }

    public Object getController() {
        return this.controller;
    }

    Map<String, TargetBean> getTargetBeans() {
        return this.targetBeans;
    }

    List<Binding> getBindings() {
        return this.bindings;
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    @Override
    public BindForm getParentBindForm() {
        return this.parentBindForm;
    }

    @Override
    public void setParentBindForm(BindForm parentBindForm) {
        this.parentBindForm = parentBindForm;
    }

    @Override
    public Binding getParentBinding() {
        return this.parentBinding;
    }

    @Override
    public void setParentBinding(Binding parentBinding) {
        this.parentBinding = parentBinding;
    }

    @Override
    public Binder getRootBinder() {
        return this.rootBinder;
    }

    @Override
    public void setRootBinder(Binder rootBinder) {
        this.rootBinder = rootBinder;
    }

    public Node getFocusedField() {
        return this.focusedField;
    }

    public void setFocusedField(Node focusedField) {
        this.focusedField = focusedField;
    }

    public static enum BindingPhase {
        INIT,
        BIND_FROM_MODEL,
        USER_INPUT,
        BIND_TO_MODEL;

    }
}

