/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.converter.string;

import com.anahata.jfx.bind.converter.Converter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDateTimeDateConverter
implements Converter<Date, LocalDateTime> {
    private static final Logger log = LoggerFactory.getLogger(LocalDateTimeDateConverter.class);
    private final DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM);

    @Override
    public String format(String value) {
        return value;
    }

    private LocalDateTime getLocalDateTime(Date date) {
        if (date != null) {
            LocalDate ld = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalTime time = date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
            return LocalDateTime.of(ld, time);
        }
        return null;
    }

    private Date getDate(LocalDateTime ldt) {
        if (ldt != null) {
            return Date.from(ldt.atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    @Override
    public Date getAsDomainModelValue(Object node, LocalDateTime nodeModelValue) {
        Date d = this.getDate(nodeModelValue);
        return d;
    }

    @Override
    public LocalDateTime getAsNodeModelValue(Object node, Date domainModelValue) {
        LocalDateTime ldt = this.getLocalDateTime(domainModelValue);
        return ldt;
    }
}

