/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.validator;

import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.validator.Validator;
import com.anahata.util.plaf.AnahataFilenameUtils;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SimpleValidator
implements Validator {
    public static final Validator FILE_NAME_INPUT_VALIDATOR = new SimpleValidator(null, 256, AnahataFilenameUtils.ILLEGAL_FILE_NAME_CHARACTERS, null, AnahataFilenameUtils.VALID_FILE_NAME_PATTERN, "Please enter a valid file name");
    private Integer minLength;
    private Integer maxLength;
    private char[] illegalCharacters;
    private String illegalCharactersMessage;
    private Pattern pattern;
    private String patternNotMatchingMessage;

    @Override
    public JfxMessage validateKeyTyped(char c) {
        if (ArrayUtils.contains((char[])this.illegalCharacters, (char)c)) {
            return JfxMessage.error(this.getIllegalCharactersMessage());
        }
        return null;
    }

    @Override
    public JfxMessage validateProgress(String text) {
        boolean valid;
        if (this.minLength != null && text.length() < this.minLength) {
            return JfxMessage.warn("The value must be at least " + this.minLength + " characters long");
        }
        if (this.maxLength != null && text.length() > this.maxLength) {
            return JfxMessage.error("The value must be " + this.maxLength + " or less characters long");
        }
        if (this.illegalCharacters != null && StringUtils.containsAny((CharSequence)text, (char[])this.illegalCharacters)) {
            return JfxMessage.error(this.getIllegalCharactersMessage());
        }
        if (this.pattern != null && !(valid = this.pattern.matcher(text).matches())) {
            return JfxMessage.warn(this.getPatternNotMatchingMessage());
        }
        return null;
    }

    @Override
    public JfxMessage validateFinal(String text) {
        return null;
    }

    public String getPatternNotMatchingMessage() {
        if (this.pattern != null && this.patternNotMatchingMessage == null) {
            return "Value not valid";
        }
        return this.patternNotMatchingMessage;
    }

    public String getIllegalCharactersMessage() {
        if (this.illegalCharactersMessage == null && this.illegalCharacters != null) {
            String illegalCharactersToString = Arrays.toString(this.illegalCharacters);
            illegalCharactersToString = illegalCharactersToString.substring(1, illegalCharactersToString.length() - 1);
            return "The following characters are not allowed: " + illegalCharactersToString;
        }
        return this.illegalCharactersMessage;
    }

    @ConstructorProperties(value={"minLength", "maxLength", "illegalCharacters", "illegalCharactersMessage", "pattern", "patternNotMatchingMessage"})
    public SimpleValidator(Integer minLength, Integer maxLength, char[] illegalCharacters, String illegalCharactersMessage, Pattern pattern, String patternNotMatchingMessage) {
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.illegalCharacters = illegalCharacters;
        this.illegalCharactersMessage = illegalCharactersMessage;
        this.pattern = pattern;
        this.patternNotMatchingMessage = patternNotMatchingMessage;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public char[] getIllegalCharacters() {
        return this.illegalCharacters;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setIllegalCharacters(char[] illegalCharacters) {
        this.illegalCharacters = illegalCharacters;
    }

    public void setIllegalCharactersMessage(String illegalCharactersMessage) {
        this.illegalCharactersMessage = illegalCharactersMessage;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPatternNotMatchingMessage(String patternNotMatchingMessage) {
        this.patternNotMatchingMessage = patternNotMatchingMessage;
    }
}

