/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.JfxUtils;
import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.BindUtils;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.Binding;
import com.anahata.jfx.bind.ValidationsImpl;
import com.anahata.jfx.bind.View;
import com.anahata.jfx.bind.nodemodel.ManualNodeModel;
import com.anahata.jfx.binding.BooleanArrayBinding;
import com.anahata.jfx.collections.DeltaListChangeListener;
import com.anahata.util.collections.ListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BindingList<C extends Node, M>
extends VBox
implements BindForm,
ManualNodeModel<BindingList, SimpleListProperty<M>> {
    private static final Logger log = LoggerFactory.getLogger(BindingList.class);
    private BindForm parentBindForm;
    private final BooleanProperty formValid = new SimpleBooleanProperty(true);
    private final BooleanProperty formModified = new SimpleBooleanProperty(false);
    private BooleanArrayBinding childValid = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.AND, new BooleanExpression[0]);
    private BooleanArrayBinding childModified = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.OR, new BooleanExpression[0]);
    private final SimpleListProperty<M> items;
    private final BooleanProperty showDeleted = new SimpleBooleanProperty(false);
    private boolean autoFocus = true;
    private final ValidationsImpl validations = new ValidationsImpl(null, Collections.emptyList());
    private final BooleanProperty containerErrors = new SimpleBooleanProperty(false);
    private Set<Object> excludes = Collections.emptySet();
    private Binding parentBinding;
    private View view;
    private final Map<Binding, View> bindingViews = new HashMap<Binding, View>();
    private Binder rootBinder;
    private boolean block = false;

    protected BindingList() {
        ObservableList observableList = FXCollections.observableArrayList();
        this.items = new SimpleListProperty(observableList);
        this.items.addListener((ListChangeListener)new DeltaListChangeListener<M>(){

            @Override
            public void onChanged(List<M> added, List<M> removed, List<M> updated) {
                if (BindingList.this.block) {
                    return;
                }
                updated = new ArrayList(BindingList.this.items.getValue());
                updated.removeAll(removed);
                for (Object item : removed) {
                    BindingList.this.removeChild(item);
                }
                for (Object item : added) {
                    BindingList.this.createControl(item);
                }
                for (Object item : updated) {
                    BindingList.this.bindFromModelChild(item);
                }
                BindingList.this.rebind();
            }
        });
    }

    public M addItem() {
        M model = this.createModel();
        this.items.add(model);
        return model;
    }

    public void clear() {
        this.block = true;
        boolean parentBlock = this.getParentBinding().getBinder().isBlock();
        this.getParentBinding().getBinder().setBlock(true);
        for (Node control : this.getChildItems()) {
            this.unbind(control);
        }
        this.getChildren().clear();
        this.rebind();
        this.block = false;
        this.getParentBinding().getBinder().setBlock(parentBlock);
    }

    @Override
    public void bindFromModel() {
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            Node node;
            Node control = node = (Node)iterator.next();
            ((BindForm)control).bindFromModel();
        }
    }

    @Override
    public void bindFromModelExcludingNode(Object excludeNode) {
        if (this.parentBindForm != null) {
            this.parentBindForm.bindFromModelExcludingNode(excludeNode);
        }
        Set<Object> excluded = BindUtils.getAllControllers(excludeNode);
        for (Node control : this.getChildItems()) {
            Set<Object> allControllers = BindUtils.getAllControllers(control);
            if (CollectionUtils.containsAny(excluded, allControllers)) continue;
            ((BindForm)control).bindFromModelExcludingNode(excludeNode);
        }
    }

    @Override
    public View getView(Binding binding) {
        View bindingView;
        if (binding != null && (bindingView = this.bindingViews.get(binding)) != null) {
            return bindingView;
        }
        if (this.view != null) {
            return this.view;
        }
        if (this.parentBindForm != null) {
            return this.parentBindForm.getView(binding);
        }
        throw new IllegalStateException("No View has been set on this BindingList: " + this);
    }

    @Override
    public void setView(View view, Binding binding) {
        if (binding == null) {
            this.view = view;
        } else {
            this.bindingViews.put(binding, view);
        }
    }

    @Override
    public void resetFormModified() {
        for (Node control : this.getChildItems()) {
            ((BindForm)control).resetFormModified();
        }
    }

    @Override
    public void validate(boolean publishError, Object ... excludeNodes) {
        Set<Object> excluded = BindUtils.getAllControllers(excludeNodes);
        for (Node control : this.getChildItems()) {
            if (excluded.contains(control)) continue;
            ((BindForm)control).validate(publishError, excludeNodes);
        }
    }

    @Override
    public Map<Node, Binding> getAllNodeBindings() {
        HashMap<Node, Binding> nodes = new HashMap<Node, Binding>();
        for (Node child : this.getChildItems()) {
            nodes.putAll(((BindForm)child).getAllNodeBindings());
        }
        return nodes;
    }

    @Override
    public BooleanProperty formValidProperty() {
        return this.formValid;
    }

    @Override
    public BooleanProperty formModifiedProperty() {
        return this.formModified;
    }

    @Override
    public BooleanProperty showContainerErrors() {
        return this.containerErrors;
    }

    @Override
    public void setExcludeNodes(Object ... nodes) {
        log.debug("Excluding nodes: {}", nodes);
        this.excludes = BindUtils.getAllControllers(nodes);
    }

    @Override
    public void setRootBinder(Binder binder) {
        this.rootBinder = binder;
        this.validations.setRootBinder(this.rootBinder);
        for (Node child : this.getChildItems()) {
            ((BindForm)child).setRootBinder(binder);
        }
    }

    @Override
    public void addValidationGroup(Class<?> validationGroup) {
        this.validations.addValidationGroup(validationGroup);
    }

    @Override
    public void removeValidationGroup(Class<?> validationGroup) {
        this.validations.removeValidationGroup(validationGroup);
    }

    @Override
    public BooleanProperty getValidationActive(Class<?> validationGroup) {
        return this.validations.getValidationActive(validationGroup);
    }

    @Override
    public ReadOnlyBooleanProperty getFormValidProperty(Class<?> validationGroup) {
        return this.validations.getFormValidProperty(validationGroup);
    }

    @Override
    public void setValid(String propertyName, Class<?> validationGroup) {
        this.validations.setValid(propertyName, validationGroup);
    }

    @Override
    public void setInvalid(String propertyName, Class<?> validationGroup) {
        this.validations.setInvalid(propertyName, validationGroup);
    }

    @Override
    public Set<Class<?>> getValidations() {
        return this.validations.getValidations();
    }

    @Override
    public void setValidationRequired() {
        this.validations.setValidationRequired();
    }

    @Override
    public SimpleListProperty<M> getNodeModelValueProperty(BindingList node) {
        return node.valueProperty();
    }

    @Override
    public void setValue(BindingList node, Object value) {
        SimpleListProperty<M> list = node.getItems();
        ListUtils.setAll(list, (List)((List)value));
        node.bindFromModel();
    }

    public SimpleListProperty<M> valueProperty() {
        return this.items;
    }

    public BooleanProperty showDeletedProperty() {
        return this.showDeleted;
    }

    protected abstract M createModel();

    protected abstract C createControl(M var1, BooleanProperty var2);

    protected abstract M getModelValue(C var1);

    protected abstract void setModelValue(C var1, M var2);

    protected void unbind(C control) {
    }

    public List<C> getChildItems() {
        ObservableList childItems = this.getChildren();
        return childItems;
    }

    private void rebind() {
        ObservableList children = this.getChildren();
        int arraySize = children.size();
        BooleanExpression[] validArray = new BooleanExpression[arraySize];
        BooleanExpression[] modifiedArray = new BooleanExpression[arraySize];
        this.validations.rebind(this.getChildItems());
        for (int i = 0; i < arraySize; ++i) {
            Node control = (Node)children.get(i);
            validArray[i] = ((BindForm)control).formValidProperty();
            modifiedArray[i] = ((BindForm)control).formModifiedProperty();
        }
        this.childValid = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.AND, validArray);
        this.childModified = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.OR, modifiedArray);
        this.formValid.bind((ObservableValue)this.childValid);
        this.formModified.bind((ObservableValue)this.childModified);
    }

    private C createControl(M modelValue) {
        C control = this.createControl(modelValue, this.showDeleted);
        ((BindForm)control).setParentBindForm(this);
        ((BindForm)control).setRootBinder(this.rootBinder);
        this.getChildren().add(control);
        if (this.autoFocus) {
            JfxUtils.focus(control);
        }
        return control;
    }

    private void removeChild(M modelValue) {
        for (Node control : this.getChildItems()) {
            M controlValue = this.getModelValue(control);
            if (!ObjectUtils.equals(modelValue, controlValue)) continue;
            this.unbind(control);
            this.getChildren().remove((Object)control);
            break;
        }
    }

    private void bindFromModelChild(M modelValue) {
        for (Node control : this.getChildItems()) {
            Set<Object> allControllers = BindUtils.getAllControllers(control);
            if (!CollectionUtils.containsAny(this.excludes, allControllers)) {
                M controlValue = this.getModelValue(control);
                if (!ObjectUtils.equals(modelValue, controlValue)) continue;
                this.setModelValue(control, modelValue);
                break;
            }
            log.debug("Excluded child from binding: {}", (Object)control);
        }
    }

    @Override
    public BindForm getParentBindForm() {
        return this.parentBindForm;
    }

    @Override
    public void setParentBindForm(BindForm parentBindForm) {
        this.parentBindForm = parentBindForm;
    }

    public SimpleListProperty<M> getItems() {
        return this.items;
    }

    public boolean isAutoFocus() {
        return this.autoFocus;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    @Override
    public Binding getParentBinding() {
        return this.parentBinding;
    }

    @Override
    public void setParentBinding(Binding parentBinding) {
        this.parentBinding = parentBinding;
    }

    @Override
    public Binder getRootBinder() {
        return this.rootBinder;
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }
}

