/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.converter.string;

import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.converter.string.BigDecimalConverter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;

public class AudBigDecimalConverter
implements Converter<BigDecimal, String> {
    public static final BigDecimalConverter INSTANCE = new BigDecimalConverter();
    private static final DecimalFormat FORMAT = (DecimalFormat)NumberFormat.getCurrencyInstance();

    @Override
    public BigDecimal getAsDomainModelValue(Object node, String nodeModelValue) {
        return !StringUtils.isBlank((CharSequence)nodeModelValue) ? new BigDecimal(StringUtils.trim((String)nodeModelValue)) : null;
    }

    @Override
    public String getAsNodeModelValue(Object node, BigDecimal domainModelValue) {
        if (domainModelValue == null) {
            return null;
        }
        FORMAT.setMinimumFractionDigits(2);
        FORMAT.setMaximumFractionDigits(2);
        return FORMAT.format(domainModelValue);
    }

    @Override
    public String format(String value) {
        return value;
    }
}

