/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.util.formatting.Displayable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Labeled;
import javafx.scene.control.TableCell;

public class RefreshableTableCell<S, T>
extends TableCell<S, T> {
    public RefreshableTableCell(BooleanProperty tableRefresh) {
        tableRefresh.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                RefreshableTableCell.this.updateIndex(RefreshableTableCell.this.getIndex());
            }
        });
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        String text = "";
        if (item != null && !empty) {
            text = item instanceof Displayable ? ((Displayable)item).getDisplayValue() : item.toString();
            this.getLabeled().setText(item.toString());
        }
        this.getLabeled().setText(text);
    }

    protected Labeled getLabeled() {
        return this;
    }
}

