/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.validator;

import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.message.JfxMessageClearContext;
import com.anahata.jfx.message.JfxMessageContext;
import com.anahata.jfx.message.JfxMessages;
import com.anahata.jfx.validator.ValidationBubble;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.scene.Node;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;

@ApplicationScoped
class DynamicValidationMarker {
    private static final String STYLE_NONE = "-fx-border-color: null; -fx-border-radius: null;";
    private static final String STYLE_WARN = "-fx-border-color: orange; -fx-border-radius: 2;";
    private static final String STYLE_ERROR = "-fx-border-color: red; -fx-border-radius: 2;";
    private Map<Node, ValidationBubble> bubbles = new WeakHashMap<Node, ValidationBubble>();

    DynamicValidationMarker() {
    }

    void processAddMessageEvent(@Observes JfxMessageContext messageEvent) {
        Node node = messageEvent.getNode();
        if (node == null) {
            return;
        }
        JfxMessage message = messageEvent.getMessage();
        if (!message.isWarnOrHigher()) {
            return;
        }
        ValidationBubble bubble = this.bubbles.get(node);
        if (bubble == null) {
            bubble = new ValidationBubble();
            this.bubbles.put(node, bubble);
        }
        bubble.show(messageEvent.getView(), node, message.getMessage());
        this.setStyleClass(node, message.getSeverity());
    }

    void processClearMessageEvent(@Observes JfxMessageClearContext context) {
        Node node = context.getNode();
        ValidationBubble bubble = this.bubbles.get(node);
        if (bubble != null) {
            bubble.hide();
        }
        this.removeStyleClasses(node);
    }

    void processClearAllMessagesEvent(@Observes JfxMessages messages) {
        System.out.println("clear all messages");
        for (Node node : this.bubbles.keySet()) {
            ValidationBubble bubble = this.bubbles.get(node);
            bubble.hide();
            this.removeStyleClasses(node);
        }
        this.bubbles.clear();
    }

    private void setStyleClass(Node node, JfxMessage.Severity severity) {
        if (severity == JfxMessage.Severity.INFO) {
            return;
        }
        node.setStyle(severity == JfxMessage.Severity.WARN ? STYLE_WARN : STYLE_ERROR);
    }

    private void removeStyleClasses(Node node) {
        node.setStyle(STYLE_NONE);
    }
}

