/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.dialog;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

class FXDialog
extends Stage {
    private static final URL DIALOGS_CSS_URL = FXDialog.class.getResource("dialogs.css");
    private BorderPane root;
    private RootPane decoratedRoot;
    private HBox windowBtns;
    private Button minButton;
    private Button maxButton;
    private Rectangle resizeCorner;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    protected Label titleLabel;
    private static final int HEADER_HEIGHT = 28;

    FXDialog(String title) {
        this(title, null, false);
    }

    FXDialog(String title, Window owner, boolean modal) {
        this(title, owner, modal, StageStyle.TRANSPARENT);
    }

    FXDialog(String title, Window owner, boolean modal, StageStyle stageStyle) {
        super(stageStyle);
        Scene scene;
        this.setTitle(title);
        if (owner != null) {
            this.initOwner(owner);
            SimpleDoubleProperty x = new SimpleDoubleProperty();
            SimpleDoubleProperty y = new SimpleDoubleProperty();
            x.addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                    FXDialog.this.setX(newValue.doubleValue());
                }
            });
            y.addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                    FXDialog.this.setY(newValue.doubleValue());
                }
            });
            this.setOnShowing((EventHandler)new EventHandler<WindowEvent>((DoubleProperty)x, owner, (DoubleProperty)y){
                final /* synthetic */ DoubleProperty val$x;
                final /* synthetic */ Window val$owner;
                final /* synthetic */ DoubleProperty val$y;
                {
                    this.val$x = doubleProperty;
                    this.val$owner = window;
                    this.val$y = doubleProperty2;
                }

                public void handle(WindowEvent t) {
                    this.val$x.unbind();
                    this.val$x.bind((ObservableValue)this.val$owner.xProperty().add((ObservableNumberValue)this.val$owner.widthProperty().subtract((ObservableNumberValue)FXDialog.this.widthProperty()).divide(2)));
                    this.val$y.unbind();
                    this.val$y.bind((ObservableValue)this.val$owner.yProperty().add((ObservableNumberValue)this.val$owner.heightProperty().subtract((ObservableNumberValue)FXDialog.this.heightProperty()).divide(2)));
                }
            });
            this.setOnHidden((EventHandler)new EventHandler<WindowEvent>((DoubleProperty)x, (DoubleProperty)y){
                final /* synthetic */ DoubleProperty val$x;
                final /* synthetic */ DoubleProperty val$y;
                {
                    this.val$x = doubleProperty;
                    this.val$y = doubleProperty2;
                }

                public void handle(WindowEvent t) {
                    this.val$x.unbind();
                    this.val$y.unbind();
                }
            });
        }
        if (modal) {
            this.initModality(Modality.WINDOW_MODAL);
        }
        this.resizableProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                FXDialog.this.resizeCorner.setVisible(FXDialog.this.isResizable());
                FXDialog.this.maxButton.setVisible(FXDialog.this.isResizable());
                if (FXDialog.this.isResizable()) {
                    FXDialog.this.windowBtns.getChildren().add(1, (Object)FXDialog.this.maxButton);
                } else {
                    FXDialog.this.windowBtns.getChildren().remove((Object)FXDialog.this.maxButton);
                }
            }
        });
        this.root = new BorderPane();
        if (stageStyle == StageStyle.DECORATED) {
            scene = new Scene((Parent)this.root);
            scene.getStylesheets().addAll((Object[])new String[]{DIALOGS_CSS_URL.toExternalForm()});
            this.setScene(scene);
            return;
        }
        this.decoratedRoot = new RootPane(){

            protected void layoutChildren() {
                super.layoutChildren();
                if (FXDialog.this.resizeCorner != null) {
                    FXDialog.this.resizeCorner.relocate(this.getWidth() - 20.0, this.getHeight() - 20.0);
                }
            }
        };
        this.decoratedRoot.getChildren().add((Object)this.root);
        scene = new Scene((Parent)this.decoratedRoot);
        String css = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return DIALOGS_CSS_URL.toExternalForm();
            }
        });
        scene.getStylesheets().addAll((Object[])new String[]{css});
        scene.setFill((Paint)Color.TRANSPARENT);
        this.setScene(scene);
        this.decoratedRoot.getStyleClass().addAll((Object[])new String[]{"dialog", "decorated-root"});
        this.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
            }
        });
        ToolBar toolBar = new ToolBar();
        toolBar.getStyleClass().add((Object)"window-header");
        toolBar.setPrefHeight(28.0);
        toolBar.setMinHeight(28.0);
        toolBar.setMaxHeight(28.0);
        toolBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FXDialog.this.mouseDragOffsetX = event.getSceneX();
                FXDialog.this.mouseDragOffsetY = event.getSceneY();
            }
        });
        toolBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FXDialog.this.setX(event.getScreenX() - FXDialog.this.mouseDragOffsetX);
                FXDialog.this.setY(event.getScreenY() - FXDialog.this.mouseDragOffsetY);
            }
        });
        this.titleLabel = new Label();
        this.titleLabel.getStyleClass().add((Object)"window-title");
        this.titleLabel.setText(this.getTitle());
        this.titleProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                FXDialog.this.titleLabel.setText(FXDialog.this.getTitle());
            }
        });
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.minButton = this.createWindowButton("minimize");
        this.minButton.setOnAction(new EventHandler(){

            public void handle(Event event) {
                FXDialog.this.setIconified(!FXDialog.this.isIconified());
            }
        });
        this.maxButton = this.createWindowButton("maximize");
        this.maxButton.setOnAction(new EventHandler(){
            private double restoreX;
            private double restoreY;
            private double restoreW;
            private double restoreH;

            public void handle(Event event) {
                Screen screen = Screen.getPrimary();
                double minX = screen.getVisualBounds().getMinX();
                double minY = screen.getVisualBounds().getMinY();
                double maxW = screen.getVisualBounds().getWidth();
                double maxH = screen.getVisualBounds().getHeight();
                if (this.restoreW == 0.0 || FXDialog.this.getX() != minX || FXDialog.this.getY() != minY || FXDialog.this.getWidth() != maxW || FXDialog.this.getHeight() != maxH) {
                    this.restoreX = FXDialog.this.getX();
                    this.restoreY = FXDialog.this.getY();
                    this.restoreW = FXDialog.this.getWidth();
                    this.restoreH = FXDialog.this.getHeight();
                    FXDialog.this.setX(minX);
                    FXDialog.this.setY(minY);
                    FXDialog.this.setWidth(maxW);
                    FXDialog.this.setHeight(maxH);
                } else {
                    FXDialog.this.setX(this.restoreX);
                    FXDialog.this.setY(this.restoreY);
                    FXDialog.this.setWidth(this.restoreW);
                    FXDialog.this.setHeight(this.restoreH);
                }
            }
        });
        this.windowBtns = new HBox(3.0);
        this.windowBtns.getStyleClass().add((Object)"window-buttons");
        this.windowBtns.getChildren().addAll((Object[])new Node[]{this.minButton, this.maxButton});
        toolBar.getItems().addAll((Object[])new Node[]{this.titleLabel, spacer, this.windowBtns});
        this.root.setTop((Node)toolBar);
        this.resizeCorner = new Rectangle(10.0, 10.0);
        this.resizeCorner.getStyleClass().add((Object)"window-resize-corner");
        EventHandler<MouseEvent> resizeHandler = new EventHandler<MouseEvent>(){
            private double width;
            private double height;
            private Point2D dragAnchor;

            public void handle(MouseEvent event) {
                EventType type = event.getEventType();
                if (type == MouseEvent.MOUSE_PRESSED) {
                    this.width = FXDialog.this.getWidth();
                    this.height = FXDialog.this.getHeight();
                    this.dragAnchor = new Point2D(event.getSceneX(), event.getSceneY());
                } else if (type == MouseEvent.MOUSE_DRAGGED) {
                    FXDialog.this.setWidth(Math.max(FXDialog.this.decoratedRoot.minWidth(-1.0), this.width + (event.getSceneX() - this.dragAnchor.getX())));
                    FXDialog.this.setHeight(Math.max(FXDialog.this.decoratedRoot.minHeight(-1.0), this.height + (event.getSceneY() - this.dragAnchor.getY())));
                }
            }
        };
        this.resizeCorner.setOnMousePressed((EventHandler)resizeHandler);
        this.resizeCorner.setOnMouseDragged((EventHandler)resizeHandler);
        this.resizeCorner.setManaged(false);
        this.decoratedRoot.getChildren().add((Object)this.resizeCorner);
    }

    void setContentPane(Pane pane) {
        if (pane.getId() == null) {
            pane.getStyleClass().add((Object)"content-pane");
        }
        this.root.setCenter((Node)pane);
    }

    private Button createWindowButton(String name) {
        StackPane graphic = new StackPane();
        graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
        Button button = new Button();
        button.getStyleClass().setAll((Object[])new String[]{"window-button"});
        button.getStyleClass().add((Object)("window-" + name + "-button"));
        button.setGraphic((Node)graphic);
        button.setMinSize(17.0, 17.0);
        button.setPrefSize(17.0, 17.0);
        return button;
    }

    private static class RootPane
    extends StackPane {
        private RootPane() {
        }
    }
}

