/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.dialog;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DialogResources {
    private static final Logger log = LoggerFactory.getLogger(DialogResources.class);
    private static final ResourceBundle dialogsResourceBundle = ResourceBundle.getBundle("com.anahata.jfx.dialog.dialog-resources");

    DialogResources() {
    }

    static String getMessage(String key) {
        try {
            return dialogsResourceBundle.getString(key);
        }
        catch (MissingResourceException ex) {
            log.error("Failed to get string for key '{}'", (Object)key);
            return key;
        }
    }

    static String getString(String key) {
        try {
            return dialogsResourceBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            log.error("Failed to get string for key '{}'", (Object)key);
            return key;
        }
    }

    static String getString(String key, Object ... args) {
        return MessageFormat.format(DialogResources.getString(key), args);
    }

    public static ImageView getIcon(final String key) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ImageView>(){

                @Override
                public ImageView run() {
                    String resourceName = DialogResources.getString(key);
                    URL url = DialogResources.class.getResource(resourceName);
                    if (url == null) {
                        log.debug("Can't create ImageView for key '{}', which has resource name '{}' and URL 'null'", (Object)key, (Object)resourceName);
                        return null;
                    }
                    return DialogResources.getIcon(url);
                }
            });
        }
        catch (Exception ex) {
            log.error("Error getting icon", (Throwable)ex);
            return null;
        }
    }

    public static ImageView getIcon(URL url) {
        return new ImageView(new Image(url.toString()));
    }
}

