/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.internal.scene.control.skin;

import com.anahata.jfx.internal.scene.control.behavior.AutoCompleteComboBoxBehavior;
import com.anahata.jfx.scene.control.AutoCompleteComboBox;
import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompleteComboBoxSkin<T>
extends ComboBoxPopupControl<T> {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteComboBoxSkin.class);
    private static final String ITEMS_PROP_NAME = "ITEMS";
    private static final String VISIBLE_ROW_COUNT_PROP_NAME = "VISIBLE_ROW_COUNT";
    private static final String CELL_FACTORY_PROP_NAME = "CELL_FACTORY";
    private static final String VALUE_PROP_NAME = "VALUE";
    private static final String SHOWING_PROP_NAME = "SHOWING";
    private static final String PROMPT_TEXT_PROP_NAME = "PROMPT_TEXT";
    private static final String EDITOR_PROP_NAME = "EDITOR";
    private static final String BUTTON_CELL = "BUTTON_CELL";
    private final AutoCompleteComboBox<T> combo;
    private ObservableList<T> comboBoxItems;
    private TextInputControl textInputControl;
    private Callback<ListView<T>, ListCell<T>> cellFactory;
    private ListView<T> listView;
    private ObservableList<T> listViewItems;
    private boolean settingText = false;
    private boolean wasComboFocused = false;

    public AutoCompleteComboBoxSkin(AutoCompleteComboBox<T> combo) {
        super(combo, new AutoCompleteComboBoxBehavior<T>(combo));
        this.combo = combo;
        this.init();
        this.initListeners();
    }

    private void init() {
        this.listView = this.createListView();
        this.textInputControl = this.createTextInputControl();
        this.getChildren().add((Object)this.textInputControl);
        this.listView.setManaged(false);
        this.getChildren().add(this.listView);
        this.updateItems();
        this.updateCellFactory();
        this.updateDisplayValue();
        this.updateValue();
    }

    private void initListeners() {
        this.registerChangeListener((ObservableValue)this.combo.itemsProperty(), ITEMS_PROP_NAME);
        this.registerChangeListener((ObservableValue)this.combo.showingProperty(), SHOWING_PROP_NAME);
        this.registerChangeListener((ObservableValue)this.combo.visibleRowCountProperty(), VISIBLE_ROW_COUNT_PROP_NAME);
        this.registerChangeListener((ObservableValue)this.combo.cellFactoryProperty(), CELL_FACTORY_PROP_NAME);
        this.registerChangeListener((ObservableValue)this.combo.valueProperty(), VALUE_PROP_NAME);
        this.registerChangeListener((ObservableValue)this.combo.editorProperty(), EDITOR_PROP_NAME);
        this.combo.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldFocus, Boolean newFocus) {
                log.trace("newFocus={}", (Object)newFocus);
                log.trace("showing= {}", (Object)AutoCompleteComboBoxSkin.this.combo.isShowing());
                AutoCompleteComboBoxSkin.this.wasComboFocused = true;
                if (AutoCompleteComboBoxSkin.this.textInputControl instanceof FakeFocusTextField) {
                    // empty if block
                }
            }
        });
        this.combo.showingProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                log.debug("combo.isShowing= {}", (Object)AutoCompleteComboBoxSkin.this.combo.isShowing());
                if (AutoCompleteComboBoxSkin.this.combo.isShowing()) {
                    AutoCompleteComboBoxSkin.this.listView.requestFocus();
                }
            }
        });
        this.combo.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                log.trace("keyCode={} target={} source={}", new Object[]{keyEvent.getCode(), keyEvent.getTarget(), keyEvent.getSource()});
                if (keyEvent.getTarget().equals(AutoCompleteComboBoxSkin.this.textInputControl)) {
                    if (keyEvent.getCode() == KeyCode.ESCAPE && AutoCompleteComboBoxSkin.this.combo.isShowing()) {
                        AutoCompleteComboBoxSkin.this.updateValue();
                        AutoCompleteComboBoxSkin.this.combo.hide();
                        keyEvent.consume();
                    }
                } else if (keyEvent.getCode() == KeyCode.ENTER) {
                    AutoCompleteComboBoxSkin.this.select();
                    keyEvent.consume();
                } else if (keyEvent.getCode() != KeyCode.F4) {
                    if (keyEvent.getCode() == KeyCode.F10) {
                        AutoCompleteComboBoxSkin.this.combo.hide();
                        keyEvent.consume();
                    } else if (keyEvent.getCode() == KeyCode.ESCAPE) {
                        log.trace("resetting value");
                        if (AutoCompleteComboBoxSkin.this.combo.isShowing()) {
                            AutoCompleteComboBoxSkin.this.updateValue();
                            AutoCompleteComboBoxSkin.this.combo.hide();
                        }
                        keyEvent.consume();
                    } else {
                        KeyEvent eventCopy = keyEvent.copyFor((Object)AutoCompleteComboBoxSkin.this.textInputControl, (EventTarget)AutoCompleteComboBoxSkin.this.textInputControl);
                        log.trace("firing event on textField={}", (Object)eventCopy);
                        AutoCompleteComboBoxSkin.this.textInputControl.fireEvent((Event)eventCopy);
                        keyEvent.consume();
                    }
                }
            }
        });
    }

    private void updateDisplayValue() {
        this.combo.show();
        this.combo.hide();
        Object item = this.combo.getValue();
        int index = this.listView.getItems().indexOf(item);
        log.trace("updateDisplay- item= {}, index= {}", item, (Object)index);
    }

    private ListView<T> createListView() {
        this.listView = new ComboListViewHelper();
        this.listView.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                log.trace("listView focused- {}", (Object)AutoCompleteComboBoxSkin.this.listView.isFocused());
            }
        });
        this.listView.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                ObservableList styleClass;
                EventTarget target = t.getTarget();
                log.trace("mouse released target= {}, parentInst= {}", (Object)target, (Object)(target instanceof Parent));
                if (target instanceof Parent && ((styleClass = ((Parent)target).getStyleClass()).contains("thumb") || styleClass.contains("track") || styleClass.contains("decrement-arrow") || styleClass.contains("increment-arrow"))) {
                    return;
                }
                AutoCompleteComboBoxSkin.this.select();
                AutoCompleteComboBoxSkin.this.combo.hide();
            }
        });
        this.listView.setFocusTraversable(false);
        return this.listView;
    }

    private void select() {
        ((AutoCompleteComboBoxBehavior)this.getBehavior()).select();
    }

    private void updateVisibleRowCount() {
        if (this.listView != null) {
            this.listView.setPrefHeight(AutoCompleteComboBoxSkin.computeListViewPrefHeight(this.listView, this.combo.getVisibleRowCount()));
        }
    }

    private void updateCellFactory() {
        Callback<ListView<T>, ListCell<T>> cf = this.combo.getCellFactory();
        this.cellFactory = cf != null ? cf : this.getDefaultCellFactory();
        this.listView.setCellFactory(this.cellFactory);
    }

    private void updateValue() {
        log.trace("updateValue");
        Object item = this.combo.getValue();
        log.trace("selected={}", item);
        this.updateDisplayValue();
        if (item != null) {
            this.settingText = true;
            String cellText = AutoCompleteComboBoxSkin.getListCellText(this.listView, item);
            log.trace("cellText={}", (Object)cellText);
            this.textInputControl.setText(cellText);
            this.textInputControl.home();
            this.settingText = false;
        } else {
            this.settingText = true;
            this.textInputControl.setText("");
            this.settingText = false;
        }
        log.trace("value= {}", this.combo.getValue());
    }

    private Callback<ListView<T>, ListCell<T>> getDefaultCellFactory() {
        return new Callback<ListView<T>, ListCell<T>>(){

            public ListCell<T> call(ListView<T> p) {
                return new ListCell<T>(){

                    protected void updateItem(T item, boolean empty) {
                        super.updateItem(item, empty);
                        if (item != null && !empty) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
            }
        };
    }

    private TextInputControl createTextInputControl() {
        this.textInputControl = this.combo.getEditor();
        this.textInputControl.promptTextProperty().bind((ObservableValue)this.combo.promptTextProperty());
        this.textInputControl.focusTraversableProperty().bindBidirectional((Property)this.combo.focusTraversableProperty());
        this.textInputControl.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                if (!AutoCompleteComboBoxSkin.this.textInputControl.isFocused()) {
                    if (StringUtils.isEmpty((CharSequence)AutoCompleteComboBoxSkin.this.textInputControl.getText())) {
                        AutoCompleteComboBoxSkin.this.combo.getSelectionModel().clearSelection();
                    }
                    AutoCompleteComboBoxSkin.this.updateValue();
                    AutoCompleteComboBoxSkin.this.combo.hide();
                }
            }
        });
        this.textInputControl.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                log.trace("textField-text={}", (Object)AutoCompleteComboBoxSkin.this.textInputControl.getText());
                AutoCompleteComboBoxSkin.this.updateFilteredItems(true);
            }
        });
        return this.textInputControl;
    }

    private void updateFilteredItems(boolean filter) {
        block5: {
            String text;
            block4: {
                if (this.settingText) {
                    log.trace("setttingText={}", (Object)this.settingText);
                    return;
                }
                text = this.textInputControl.getText();
                if (!filter || StringUtils.isEmpty((CharSequence)text)) break block4;
                ObservableList filtered = FXCollections.observableArrayList();
                for (Object item : this.combo.getItems()) {
                    if (!this.combo.getDataFilter().matches(item, text)) continue;
                    filtered.add(item);
                }
                this.listView.setItems(filtered);
                this.listView.getSelectionModel().clearSelection();
                this.combo.clearSelection();
                if (this.combo.isShowing()) break block5;
                this.combo.show();
                break block5;
            }
            this.listView.getSelectionModel().clearSelection();
            this.updateItems();
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                for (Object item : this.combo.getItems()) {
                    if (!this.combo.getDataFilter().matches(item, text)) continue;
                    this.listView.getSelectionModel().select(item);
                    break;
                }
            }
        }
    }

    private void configurePopup() {
        if (!this.getPopup().isShowing()) {
            return;
        }
        Point2D point = this.getPrefPopupPosition();
        this.configurePopup(point.getX(), point.getY(), this.getPopupContent().prefWidth(1.0), this.getPopupContent().prefHeight(1.0));
    }

    private void configurePopup(double x, double y, double minWidth, double minHeight) {
        if (!this.getPopup().isShowing()) {
            return;
        }
        if (x > -1.0) {
            this.getPopup().setX(x);
        }
        if (y > -1.0) {
            this.getPopup().setY(y);
        }
        if (minWidth > -1.0) {
            this.getPopup().setMinWidth(minWidth);
        }
        if (minHeight > -1.0) {
            this.getPopup().setMinHeight(minHeight);
        }
    }

    private Point2D getPrefPopupPosition() {
        return Utils.pointRelativeTo((Node)this.getSkinnable(), (Node)this.getPopupContent(), (HPos)HPos.CENTER, (VPos)VPos.BOTTOM, (double)-7.0, (double)-10.0, (boolean)true);
    }

    protected void handleControlPropertyChanged(String property) {
        log.trace("handlePropertyChanged={}", (Object)property);
        if (SHOWING_PROP_NAME.equals(property)) {
            if (this.combo.isShowing()) {
                this.listView.setManaged(true);
                this.updateFilteredItems(false);
            } else {
                this.listView.setManaged(false);
            }
        }
        super.handleControlPropertyChanged(property);
        switch (property) {
            case "ITEMS": {
                this.updateItems();
                break;
            }
            case "VISIBLE_ROW_COUNT": {
                this.updateVisibleRowCount();
                break;
            }
            case "CELL_FACTORY": {
                this.updateCellFactory();
                break;
            }
            case "VALUE": {
                this.updateValue();
                break;
            }
            case "EDITOR": {
                this.textInputControl = this.createTextInputControl();
            }
        }
    }

    protected Node getPopupContent() {
        return this.listView;
    }

    public Node getDisplayNode() {
        return this.textInputControl;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 60.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double superPW = super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        double lvPW = this.listView.prefWidth(height);
        double pw = Math.max(superPW, lvPW);
        this.configurePopup();
        return pw;
    }

    public final void updateItems() {
        log.trace("updateItems");
        this.listViewItems = this.combo.getItems();
        this.listView.setItems(null);
        this.listView.setItems(this.listViewItems);
        ((ComboBoxBase)this.getSkinnable()).requestLayout();
        AutoCompleteComboBoxSkin.refreshListView(this.listView);
    }

    public ListView<T> getListView() {
        return this.listView;
    }

    private static <T> double getMaxCellWidth(ListView listView) {
        return AutoCompleteComboBoxSkin.getMaxCellWidth(listView, -1);
    }

    private static <T> double getMaxCellWidth(ListView listView, int rowsToCount) {
        double cellWidth;
        log.trace("getMaxCellWidth");
        Validate.notNull((Object)listView);
        if (rowsToCount < 1) {
            rowsToCount = -1;
        }
        if (listView.getSkin() instanceof VirtualContainerBase) {
            try {
                VirtualContainerBase skin = (VirtualContainerBase)listView.getSkin();
                Method getMaxCellWidthMethod = skin.getClass().getSuperclass().getDeclaredMethod("getMaxCellWidth", Integer.TYPE);
                getMaxCellWidthMethod.setAccessible(true);
                cellWidth = (Double)getMaxCellWidthMethod.invoke((Object)skin, rowsToCount);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.warn("Encountered error", (Throwable)e);
                cellWidth = Math.max(50.0, listView.getPrefWidth());
            }
        } else {
            cellWidth = Math.max(50.0, listView.getPrefWidth());
        }
        log.trace("returning cellWidth= " + cellWidth);
        return cellWidth;
    }

    private static <T> String getListCellText(ListView<T> listView, T item) {
        Validate.notNull(listView);
        Validate.notNull(item);
        int index = listView.getItems().indexOf(item);
        String text = "";
        if (index != -1) {
            text = AutoCompleteComboBoxSkin.getListCellText(listView, index);
        }
        log.trace("getListCellText item= {}, index= {}, text= {}", new Object[]{item, index, text});
        return text;
    }

    private static <T> String getListCellText(ListView<T> listView, int index) {
        ListCell<T> cell = AutoCompleteComboBoxSkin.getListCell(listView, index);
        return cell == null ? "" : cell.getText();
    }

    private static <T> ListCell<T> getListCell(ListView<T> listView, int index) {
        Validate.notNull(listView);
        if (index < 0) {
            return null;
        }
        ListCell cell = null;
        if (listView.getSkin() instanceof VirtualContainerBase) {
            try {
                VirtualContainerBase skin = (VirtualContainerBase)listView.getSkin();
                Field flowField = skin.getClass().getSuperclass().getDeclaredField("flow");
                flowField.setAccessible(true);
                VirtualFlow flow = (VirtualFlow)flowField.get(skin);
                Method getCellMethod = flow.getClass().getDeclaredMethod("getCell", Integer.TYPE);
                getCellMethod.setAccessible(true);
                cell = (ListCell)getCellMethod.invoke((Object)flow, index);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.warn("Encountered error", (Throwable)e);
            }
        }
        log.trace("getListCell cell={} textInCell= {}", cell, (Object)cell.getText());
        return cell;
    }

    private static <T> void refreshListView(ListView<T> listView) {
        Validate.notNull(listView);
        log.trace("refreshing listView={}", listView);
        log.trace("refreshing listView itemCount={}", (Object)listView.getItems().size());
        if (listView.getSkin() instanceof VirtualContainerBase) {
            try {
                VirtualContainerBase skin = (VirtualContainerBase)listView.getSkin();
                Field flowField = skin.getClass().getSuperclass().getDeclaredField("flow");
                flowField.setAccessible(true);
                VirtualFlow flow = (VirtualFlow)flowField.get(skin);
                flow.recreateCells();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                log.warn("Encountered error", (Throwable)e);
            }
        }
    }

    private static double computeListViewPrefHeight(ListView listView, int maxRows) {
        double ph;
        Validate.notNull((Object)listView);
        if (maxRows < 0) {
            maxRows = 5;
        }
        if (listView.getSkin() instanceof VirtualContainerBase) {
            try {
                VirtualContainerBase skin = (VirtualContainerBase)listView.getSkin();
                Method getVirtualFlowPreferredHeightMethod = skin.getClass().getSuperclass().getDeclaredMethod("getVirtualFlowPreferredHeight", Integer.TYPE);
                getVirtualFlowPreferredHeightMethod.setAccessible(true);
                ph = (Double)getVirtualFlowPreferredHeightMethod.invoke((Object)skin, maxRows);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.warn("Encountered error", (Throwable)e);
                double itemsPref = listView.getItems().size() * 25;
                ph = Math.min(itemsPref, 200.0);
            }
        } else {
            double itemsPref = listView.getItems().size() * 25;
            ph = Math.min(itemsPref, 200.0);
        }
        log.debug("lv-ph= {}", (Object)ph);
        return ph;
    }

    class ComboListViewHelper<T>
    extends ListView<T> {
        protected double computeMinHeight(double d) {
            log.debug("compute mh d= {}", (Object)d);
            return 60.0;
        }

        protected double computePrefHeight(double d) {
            double ph = AutoCompleteComboBoxSkin.computeListViewPrefHeight(this, AutoCompleteComboBoxSkin.this.combo.getVisibleRowCount());
            log.debug("clv helper ph= {}", (Object)ph);
            return ph;
        }

        protected double computePrefWidth(double d) {
            double pw = Math.max(AutoCompleteComboBoxSkin.this.combo.getWidth(), AutoCompleteComboBoxSkin.this.combo.getPrefListViewWidth());
            return pw;
        }
    }

    public static final class FakeFocusTextField
    extends TextField {
        public void setFakeFocus(boolean value) {
            this.setFocused(value);
        }
    }
}

