/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind2;

import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.filter.KeystrokeFilter;
import com.anahata.jfx.bind2.BindForm;
import com.anahata.jfx.bind2.BindNode;
import com.anahata.jfx.bind2.BindView;
import com.anahata.jfx.validator.FieldValidator;
import com.anahata.util.reflect.AnahataPropertyUtils;
import javafx.beans.property.ObjectProperty;
import org.apache.commons.beanutils.NestedNullException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindField {
    private static final Logger log = LoggerFactory.getLogger(BindField.class);
    private final String fieldId;
    private final String modelId;
    private final BindForm bindForm;
    private final ObjectProperty<?> model;
    private final String propName;
    private final Object node;
    private BindNode bindNode;
    private final BindView bindView;
    private final Converter converter;
    private final FieldValidator fieldValidator;
    private final KeystrokeFilter keystrokeFilter;

    public BindField(String modelId, BindForm bindForm, ObjectProperty<?> model, String propName, Object node, BindView bindView, Converter converter, FieldValidator fieldValidator, KeystrokeFilter keystrokeFilter) {
        this.fieldId = modelId + "." + propName;
        this.modelId = modelId;
        this.bindForm = bindForm;
        this.model = model;
        this.propName = propName;
        this.node = node;
        this.bindView = bindView;
        this.converter = converter;
        this.fieldValidator = fieldValidator;
        this.keystrokeFilter = keystrokeFilter;
        if (node instanceof BindNode) {
            this.bindNode = (BindNode)node;
            this.bindNode.register(this);
        }
    }

    public void setNodeValue() {
        Object value;
        if (this.model.getValue() == null) {
            return;
        }
        try {
            value = AnahataPropertyUtils.getProperty((Object)this.model.getValue(), (String)this.propName);
        }
        catch (NestedNullException e) {
            value = null;
        }
        if (this.converter != null) {
            try {
                value = this.converter.getAsNodeModelValue(this.model.getValue(), value);
            }
            catch (RuntimeException e) {
                log.error("Exception converting model value to node value for : " + this.propName, (Throwable)e);
                throw e;
            }
        }
        log.debug("Setting node value: model=[{}] field=[{}] value=[{}]", new Object[]{this.modelId, this.model.getValue().getClass().getSimpleName() + "." + this.propName, value});
        this.bindNode.setValue(this.node, value);
    }

    public void setModelValue(Object value) {
        if (this.model.getValue() == null || this.bindForm.isBinding()) {
            return;
        }
        log.debug("Setting model value: model=[{}] field=[{}] value=[{}]", new Object[]{this.modelId, this.model.getValue().getClass().getSimpleName() + "." + this.propName, value});
        if (this.converter != null) {
            value = this.converter.getAsDomainModelValue(this.node, value);
        }
        AnahataPropertyUtils.setPropertyNulls((Object)this.model.getValue(), (String)this.propName, (Object)value);
        this.bindForm.notifyModelUpdated(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BindField)) {
            return false;
        }
        BindField other = (BindField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldId = this.getFieldId();
        String other$fieldId = other.getFieldId();
        return !(this$fieldId == null ? other$fieldId != null : !this$fieldId.equals(other$fieldId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BindField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldId = this.getFieldId();
        result = result * 59 + ($fieldId == null ? 0 : $fieldId.hashCode());
        return result;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getModelId() {
        return this.modelId;
    }

    public BindForm getBindForm() {
        return this.bindForm;
    }

    public ObjectProperty<?> getModel() {
        return this.model;
    }

    public String getPropName() {
        return this.propName;
    }

    public Object getNode() {
        return this.node;
    }

    public BindNode getBindNode() {
        return this.bindNode;
    }

    public BindView getBindView() {
        return this.bindView;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public FieldValidator getFieldValidator() {
        return this.fieldValidator;
    }

    public KeystrokeFilter getKeystrokeFilter() {
        return this.keystrokeFilter;
    }
}

