/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx;

import com.anahata.jfx.concurrent.ApplicationTask;
import com.anahata.util.transport.RemoteServiceProxy;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFxRemoteServiceProxy
extends RemoteServiceProxy {
    private static final Logger log = LoggerFactory.getLogger(JavaFxRemoteServiceProxy.class);

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        log.debug("method {} ", (Object)method);
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        if (Platform.isFxApplicationThread()) {
            if (this.nodeToDisable != null) {
                this.nodeToDisable.disableProperty().unbind();
            }
            final Object key = new Object();
            ApplicationTask applicationTask = new ApplicationTask(){

                protected Object call() throws Exception {
                    return method.invoke(JavaFxRemoteServiceProxy.this.service, args);
                }

                protected void succeeded() {
                    Toolkit.getToolkit().exitNestedEventLoop(key, super.getValue());
                }

                protected void failed() {
                    super.failed();
                    Toolkit.getToolkit().exitNestedEventLoop(key, (Object)super.getException());
                }
            };
            if (this.nodeToDisable != null) {
                this.nodeToDisable.disableProperty().bind((ObservableValue)applicationTask.runningProperty());
            }
            applicationTask.launch();
            Object returnObj = Toolkit.getToolkit().enterNestedEventLoop(key);
            if (returnObj instanceof Throwable) {
                throw (Throwable)returnObj;
            }
            return returnObj;
        }
        return method.invoke(this.service, args);
    }

    public static <T> T newAsynchProxy(T service, Node node) {
        JavaFxRemoteServiceProxy proxy = new JavaFxRemoteServiceProxy();
        proxy.setService(service);
        proxy.setNodeToDisable(node);
        return (T)Proxy.newProxyInstance(service.getClass().getClassLoader(), ClassUtils.getAllInterfaces(service.getClass()).toArray(new Class[0]), (InvocationHandler)((Object)proxy));
    }
}

