/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.currency;

import java.beans.ConstructorProperties;
import java.util.Currency;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;

public class CurrencyListViewCellFactory
implements Callback<ListView<Currency>, ListCell<Currency>> {
    public static final CurrencyListViewCellFactory MEDIUM_INSTANCE = new CurrencyListViewCellFactory(false);
    public static final CurrencyListViewCellFactory LONG_INSTANCE = new CurrencyListViewCellFactory(true);
    final boolean longStyle;

    public ListCell<Currency> call(ListView<Currency> param) {
        return new CurrencyCell();
    }

    @ConstructorProperties(value={"longStyle"})
    public CurrencyListViewCellFactory(boolean longStyle) {
        this.longStyle = longStyle;
    }

    private class CurrencyCell
    extends ListCell<Currency> {
        protected void updateItem(Currency item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
            } else if (CurrencyListViewCellFactory.this.longStyle) {
                this.setText(item.getCurrencyCode() + " - " + item.getDisplayName());
            } else {
                this.setText(item.getCurrencyCode());
            }
        }
    }
}

