/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.binding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import org.apache.commons.lang3.Validate;

public class BooleanArrayBinding
extends BooleanBinding {
    private BindingMode bindingMode;
    private List<? extends BooleanExpression> booleans;

    public <T extends BooleanExpression> BooleanArrayBinding(BindingMode bindingMode, T ... booleans) {
        Validate.notNull((Object)((Object)bindingMode));
        this.bindingMode = bindingMode;
        if (booleans != null) {
            this.booleans = new ArrayList<T>(Arrays.asList(booleans));
        }
        super.bind(booleans);
    }

    public BooleanArrayBinding(BindingMode bindingMode, Collection<? extends BooleanExpression> booleans) {
        Validate.notNull((Object)((Object)bindingMode));
        this.bindingMode = bindingMode;
        if (booleans != null) {
            this.booleans = new ArrayList<BooleanExpression>(booleans);
            super.bind((Observable[])booleans.toArray(new BooleanExpression[booleans.size()]));
        } else {
            super.bind((Observable[])new BooleanExpression[0]);
        }
    }

    protected boolean computeValue() {
        if (this.bindingMode == BindingMode.AND) {
            return this.computeAnd();
        }
        return this.computeOr();
    }

    private boolean computeAnd() {
        for (BooleanExpression booleanExpression : this.booleans) {
            if (booleanExpression.get()) continue;
            return false;
        }
        return true;
    }

    private boolean computeOr() {
        for (BooleanExpression booleanExpression : this.booleans) {
            if (!booleanExpression.get()) continue;
            return true;
        }
        return false;
    }

    public static enum BindingMode {
        AND,
        OR;

    }
}

