/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.table;

import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.BindUtils;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.Binding;
import com.anahata.jfx.bind.ValidationsImpl;
import com.anahata.jfx.bind.View;
import com.anahata.jfx.bind.table.BindingTableRow;
import com.anahata.jfx.binding.BooleanArrayBinding;
import com.anahata.jfx.collections.DeltaListChangeListener;
import com.anahata.util.cdi.Cdi;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingTableView
implements BindForm {
    private static final Logger log = LoggerFactory.getLogger(BindingTableView.class);
    private TableView tableView;
    private Class<? extends BindingTableRow> tableRowClass;
    private final List<BindingTableRow> tableRows = new ArrayList<BindingTableRow>();
    private List<BooleanExpression> tableValids = new ArrayList<BooleanExpression>();
    private List<BooleanExpression> tableModifieds = new ArrayList<BooleanExpression>();
    private BooleanProperty formValid = new SimpleBooleanProperty(true);
    private BooleanProperty formModified = new SimpleBooleanProperty(false);
    private BindForm parentBindForm;
    private Binding parentBinding;
    private ObjectProperty userData = new SimpleObjectProperty();
    private final ValidationsImpl validations = new ValidationsImpl(null, Collections.emptyList());
    private BooleanProperty containerErrors = new SimpleBooleanProperty(false);
    private View view;
    private final Map<Binding, View> bindingViews = new HashMap<Binding, View>();
    private final BooleanProperty readOnly = new SimpleBooleanProperty();
    private Binder rootBinder;

    public BindingTableView(TableView tableView, Class<? extends BindingTableRow> tableRowClass) {
        Validate.notNull((Object)tableView);
        Validate.isTrue((tableView.getUserData() == null ? 1 : 0) != 0, (String)"userData for the passed TableView is not null: %s", (Object[])new Object[]{tableView.getUserData()});
        Validate.notNull(tableRowClass);
        this.tableView = tableView;
        tableView.setUserData((Object)this);
        this.tableRowClass = tableRowClass;
        tableView.setRowFactory((Callback)new Callback<TableView, TableRow>(){

            public TableRow call(TableView tv) {
                BindingTableRow tableRow = (BindingTableRow)Cdi.get((Class)BindingTableView.this.tableRowClass, (Annotation[])new Annotation[0]);
                tableRow.setBindingTableView(BindingTableView.this);
                tableRow.setParentBindForm(BindingTableView.this);
                tableRow.readOnlyProperty().bind((ObservableValue)BindingTableView.this.readOnly);
                log.debug("Setting rootBinder on BindingTableRow, rootBinder.controller={}", (Object)BindingTableView.this.rootBinder.getController().getClass().getSimpleName());
                tableRow.setRootBinder(BindingTableView.this.rootBinder);
                BindingTableView.this.addTableRow(tableRow);
                return tableRow;
            }
        });
        List<TableColumn> leafColumns = BindingTableView.getLeafColumns(tableView);
        BindingTableRow tempRow = (BindingTableRow)Cdi.get(tableRowClass, (Annotation[])new Annotation[0]);
        HashSet<String> columnIds = new HashSet<String>();
        log.debug("Processing columns of TableView {}, total leaf columns: {}", (Object)tableView.getId(), (Object)leafColumns.size());
        for (int i = 0; i < leafColumns.size(); ++i) {
            final TableColumn column = leafColumns.get(i);
            log.debug("Processing column #{} id={}", (Object)i, (Object)column.getId());
            if (column.getId() == null) continue;
            columnIds.add(column.getId());
            Object target = tempRow.getTarget(column.getId());
            if (target == null) continue;
            if (target instanceof Node) {
                column.setCellFactory((Callback)new Callback<TableColumn, TableCell>(){

                    public TableCell call(TableColumn tc) {
                        return new TableCell(){

                            protected void updateItem(Object item, boolean empty) {
                                super.updateItem(item, empty);
                                TableRow row = super.getTableRow();
                                Node graphic = null;
                                log.debug("item= {}", item);
                                if (row != null && row.getItem() != null) {
                                    BindingTableRow bindingTableRow = (BindingTableRow)row;
                                    graphic = (Node)bindingTableRow.getTarget(column.getId());
                                    log.debug("graphic= {}", (Object)graphic);
                                    String styleClass = bindingTableRow.getStyleClass(column.getId());
                                    if (styleClass != null) {
                                        this.getStyleClass().add((Object)styleClass);
                                    }
                                }
                                this.setGraphic(graphic);
                            }
                        };
                    }
                });
            }
            column.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures, ObservableValue>(){

                public ObservableValue call(TableColumn.CellDataFeatures features) {
                    BindingTableView btv = (BindingTableView)features.getTableView().getUserData();
                    BindingTableRow btr = btv.getRow(features.getValue());
                    if (btr == null) {
                        return new ReadOnlyObjectWrapper(null);
                    }
                    Object modelValue = btr.getModelValue(column.getId());
                    log.debug("cell value factory: value={} columnId={}, model={}", new Object[]{modelValue, column.getId(), btr.getModel()});
                    return new ReadOnlyObjectWrapper(modelValue);
                }
            });
        }
        Collection missingIds = CollectionUtils.subtract(tempRow.getColumnIds(), columnIds);
        Validate.validState((boolean)missingIds.isEmpty(), (String)"There are id's defined in the BindingTableRow [%s] of TableView [%s] without a corresponding leaf TableColumn id: %s. Available leaf TableColumn ids are: %s", (Object[])new Object[]{tableRowClass.getSimpleName(), tableView.getId(), missingIds, columnIds});
        tableView.getItems().addListener((ListChangeListener)new DeltaListChangeListener(){

            protected void onChanged(List added, List removed, List updated) {
                if (updated.isEmpty() && removed.isEmpty()) {
                    return;
                }
                HashMap updatedMap = new HashMap();
                for (Object obj : updated) {
                    updatedMap.put(obj, obj);
                }
                HashSet removedSet = new HashSet(removed);
                for (BindingTableRow tableRow : BindingTableView.this.tableRows) {
                    if (!tableRow.isHasValue()) continue;
                    if (updatedMap.containsKey(tableRow.getModel())) {
                        log.debug("Binding from model updated tablerow: {} model: {}", (Object)tableRow, tableRow.getModel());
                        tableRow.modelProperty().set(updatedMap.get(tableRow.getModel()));
                        tableRow.bindFromModel();
                        tableRow.updateItem();
                        continue;
                    }
                    if (!removedSet.contains(tableRow.getModel())) continue;
                    log.debug("Setting to no value removed tablerow: {} model: {}", (Object)tableRow, tableRow.getModel());
                    tableRow.setHasValue(false);
                }
            }
        });
        this.userData.addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                log.debug("Refreshing userData to table rows");
                for (BindingTableRow tableRow : BindingTableView.this.tableRows) {
                    tableRow.updateItem();
                }
            }
        });
    }

    public static BindingTableView get(TableView table) {
        return (BindingTableView)table.getUserData();
    }

    @Override
    public void bindFromModel() {
        for (BindingTableRow tableRow : this.tableRows) {
            log.debug("bindFromModel: Binding tablerow: {} model: {}", (Object)tableRow, tableRow.getModel());
            tableRow.bindFromModel();
        }
    }

    @Override
    public void bindFromModelExcludingNode(Object excludeNode) {
        if (this.parentBindForm != null) {
            this.parentBindForm.bindFromModelExcludingNode(excludeNode);
        }
    }

    public boolean bindFromModel(Object model) {
        boolean found = true;
        for (BindingTableRow row : this.tableRows) {
            if (!ObjectUtils.equals((Object)model, row.getModel()) || !row.isHasValue()) continue;
            log.info("Found row for model and set value: {}", (Object)row);
            row.bindFromModel();
            found = true;
        }
        return found;
    }

    @Override
    public View getView(Binding binding) {
        View bindingView;
        if (binding != null && (bindingView = this.bindingViews.get(binding)) != null) {
            return bindingView;
        }
        if (this.view != null) {
            return this.view;
        }
        if (this.parentBindForm != null) {
            return this.parentBindForm.getView(binding);
        }
        throw new IllegalStateException("No View has been set on this binder: " + this);
    }

    @Override
    public void setView(View view, Binding binding) {
        if (binding == null) {
            this.view = view;
        } else {
            this.bindingViews.put(binding, view);
        }
    }

    @Override
    public void resetFormModified() {
        for (BindingTableRow tableRow : this.tableRows) {
            tableRow.resetFormModified();
        }
    }

    @Override
    public void validate(boolean publishError, Object ... excludeNodes) {
        Set<Object> excluded = BindUtils.getAllControllers(excludeNodes);
        for (BindingTableRow tableRow : this.tableRows) {
            if (excluded.contains(tableRow)) continue;
            tableRow.validate(publishError, excludeNodes);
        }
    }

    @Override
    public Map<Node, Binding> getAllNodeBindings() {
        HashMap<Node, Binding> nodes = new HashMap<Node, Binding>();
        for (BindingTableRow tableRow : this.tableRows) {
            if (!tableRow.isHasValue()) continue;
            nodes.putAll(tableRow.getAllNodeBindings());
        }
        return nodes;
    }

    @Override
    public BooleanProperty formValidProperty() {
        return this.formValid;
    }

    @Override
    public BooleanProperty formModifiedProperty() {
        return this.formModified;
    }

    @Override
    public BooleanProperty showContainerErrors() {
        return this.containerErrors;
    }

    @Override
    public void setExcludeNodes(Object ... nodes) {
    }

    @Override
    public void setRootBinder(Binder rootBinder) {
        this.rootBinder = rootBinder;
        this.validations.setRootBinder(rootBinder);
        for (BindingTableRow row : this.tableRows) {
            row.setRootBinder(rootBinder);
        }
    }

    @Override
    public void addValidationGroup(Class<?> validationGroup) {
        this.validations.addValidationGroup(validationGroup);
    }

    @Override
    public void removeValidationGroup(Class<?> validationGroup) {
        this.validations.removeValidationGroup(validationGroup);
    }

    @Override
    public BooleanProperty getValidationActive(Class<?> validationGroup) {
        return this.validations.getValidationActive(validationGroup);
    }

    @Override
    public ReadOnlyBooleanProperty getFormValidProperty(Class<?> validationGroup) {
        return this.validations.getFormValidProperty(validationGroup);
    }

    @Override
    public void setValid(String propertyName, Class<?> validationGroup) {
        this.validations.setValid(propertyName, validationGroup);
    }

    @Override
    public void setInvalid(String propertyName, Class<?> validationGroup) {
        this.validations.setInvalid(propertyName, validationGroup);
    }

    @Override
    public Set<Class<?>> getValidations() {
        return this.validations.getValidations();
    }

    @Override
    public void setValidationRequired() {
        for (BindingTableRow row : this.getTableRows()) {
            row.setValidationRequired();
        }
    }

    public boolean isReadOnly() {
        return this.readOnly.get();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly.set(readOnly);
    }

    public BooleanProperty readOnlyProperty() {
        return this.readOnly;
    }

    public ObjectProperty userDataProperty() {
        return this.userData;
    }

    public Object getUserData() {
        return this.userData.get();
    }

    public void setUserData(Object userData) {
        this.userData.set(userData);
    }

    public BindingTableRow getSelectedRow() {
        for (BindingTableRow row : this.tableRows) {
            if (!row.isSelected()) continue;
            return row;
        }
        return null;
    }

    public BindingTableRow getRow(Object model) {
        if (model == null) {
            return null;
        }
        for (BindingTableRow row : this.tableRows) {
            if (!ObjectUtils.equals((Object)model, row.getModel()) || !row.isHasValue()) continue;
            return row;
        }
        return null;
    }

    private void addTableRow(BindingTableRow tableRow) {
        this.tableRows.add(tableRow);
        this.tableValids.add((BooleanExpression)tableRow.formValidProperty());
        this.tableModifieds.add((BooleanExpression)tableRow.formModifiedProperty());
        this.formModified.unbind();
        this.formModified.bind((ObservableValue)new BooleanArrayBinding(BooleanArrayBinding.BindingMode.OR, (Collection<? extends BooleanExpression>)this.tableModifieds));
        this.formValid.unbind();
        this.formValid.bind((ObservableValue)new BooleanArrayBinding(BooleanArrayBinding.BindingMode.AND, (Collection<? extends BooleanExpression>)this.tableValids));
        this.validations.rebind(this.tableRows);
    }

    private static List<TableColumn> getLeafColumns(TableView tableView) {
        ArrayList<TableColumn> ret = new ArrayList<TableColumn>();
        for (TableColumn tc : tableView.getColumns()) {
            List<TableColumn> leafs = BindingTableView.getLeafColumns(tc);
            ret.addAll(leafs);
        }
        return ret;
    }

    private static List<TableColumn> getLeafColumns(TableColumn tc) {
        ArrayList<TableColumn> ret = new ArrayList<TableColumn>();
        if (tc.getColumns().isEmpty()) {
            ret.add(tc);
        } else {
            for (Object child : tc.getColumns()) {
                ret.addAll(BindingTableView.getLeafColumns((TableColumn)child));
            }
        }
        if (log.isDebugEnabled() && ret.size() > 1) {
            log.debug("leaf colums of {}: {}", (Object)tc.getId(), (Object)ret.size());
        }
        return ret;
    }

    public void bindFromModelRowsWithValue() {
        for (BindingTableRow row : this.getTableRows()) {
            if (!row.isHasValue()) continue;
            row.bindFromModel();
        }
    }

    public TableView getTableView() {
        return this.tableView;
    }

    public List<BindingTableRow> getTableRows() {
        return this.tableRows;
    }

    @Override
    public BindForm getParentBindForm() {
        return this.parentBindForm;
    }

    @Override
    public void setParentBindForm(BindForm parentBindForm) {
        this.parentBindForm = parentBindForm;
    }

    @Override
    public Binding getParentBinding() {
        return this.parentBinding;
    }

    @Override
    public void setParentBinding(Binding parentBinding) {
        this.parentBinding = parentBinding;
    }

    @Override
    public Binder getRootBinder() {
        return this.rootBinder;
    }
}

