/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.dialog;

import com.anahata.jfx.dialog.DialogOptions;
import com.anahata.jfx.dialog.DialogResponse;
import com.anahata.jfx.dialog.DialogTemplate;
import com.anahata.jfx.dialog.DialogType;
import com.anahata.jfx.validator.Validator;
import com.anahata.util.error.ErrorDetail;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.stage.Stage;

public class Dialogs {
    public static DialogResponse showConfirmDialog(Stage owner, String message) {
        return Dialogs.showConfirmDialog(owner, message, DialogType.CONFIRMATION.getDefaultMasthead());
    }

    public static DialogResponse showConfirmDialog(Stage owner, String message, String masthead) {
        return Dialogs.showConfirmDialog(owner, message, masthead, DialogType.CONFIRMATION.getDefaultTitle());
    }

    public static DialogResponse showConfirmDialog(Stage owner, String message, String masthead, String title) {
        return Dialogs.showConfirmDialog(owner, message, masthead, title, DialogType.CONFIRMATION.getDefaultOptions());
    }

    public static DialogResponse showConfirmDialog(Stage owner, String message, String masthead, String title, DialogOptions options) {
        return Dialogs.showSimpleContentDialog(owner, title, masthead, message, DialogType.CONFIRMATION, options);
    }

    public static void showInformationDialog(Stage owner, String message) {
        Dialogs.showInformationDialog(owner, message, DialogType.INFORMATION.getDefaultMasthead());
    }

    public static void showInformationDialog(Stage owner, String message, String masthead) {
        Dialogs.showInformationDialog(owner, message, masthead, DialogType.INFORMATION.getDefaultTitle());
    }

    public static void showInformationDialog(Stage owner, String message, String masthead, String title) {
        Dialogs.showSimpleContentDialog(owner, title, masthead, message, DialogType.INFORMATION, DialogType.INFORMATION.getDefaultOptions());
    }

    public static DialogResponse showWarningDialog(Stage owner, String message) {
        return Dialogs.showWarningDialog(owner, message, DialogType.WARNING.getDefaultMasthead());
    }

    public static DialogResponse showWarningDialog(Stage owner, String message, String masthead) {
        return Dialogs.showWarningDialog(owner, message, masthead, DialogType.WARNING.getDefaultTitle());
    }

    public static DialogResponse showWarningDialog(Stage owner, String message, String masthead, String title) {
        return Dialogs.showWarningDialog(owner, message, masthead, title, DialogType.WARNING.getDefaultOptions());
    }

    public static DialogResponse showWarningDialog(Stage owner, String message, String masthead, String title, DialogOptions options) {
        return Dialogs.showSimpleContentDialog(owner, title, masthead, message, DialogType.WARNING, options);
    }

    public static DialogResponse showErrorDialog(Stage owner, String message) {
        return Dialogs.showErrorDialog(owner, message, DialogType.ERROR.getDefaultMasthead());
    }

    public static DialogResponse showErrorDialog(Stage owner, String message, String masthead) {
        return Dialogs.showErrorDialog(owner, message, masthead, masthead);
    }

    public static DialogResponse showErrorDialog(Stage owner, String message, String masthead, String title) {
        return Dialogs.showErrorDialog(owner, message, masthead, title, DialogType.ERROR.getDefaultOptions());
    }

    public static DialogResponse showErrorDialog(Stage owner, String message, String masthead, String title, DialogOptions options) {
        return Dialogs.showSimpleContentDialog(owner, title, masthead, message, DialogType.ERROR, options);
    }

    public static DialogResponse showErrorDialog(Stage owner, String message, String masthead, String title, Throwable throwable) {
        DialogTemplate template = new DialogTemplate(owner, title, masthead, null);
        template.setErrorContent(message, throwable);
        return Dialogs.showDialog(template);
    }

    public static DialogResponse showAdvancedErrorDialog(Stage owner, String message, String masthead, String title, ErrorDetail errorDetail) {
        DialogTemplate template = new DialogTemplate(owner, title, masthead, null);
        template.setAdvancedErrorContent(message, errorDetail);
        return Dialogs.showDialog(template);
    }

    public static DialogResponse showReportIssueDialog(Stage owner, String message, String masthead, String title, ErrorDetail errorDetail) {
        DialogTemplate template = new DialogTemplate(owner, title, masthead, null);
        template.setReportIssueContent(message, errorDetail);
        return Dialogs.showDialog(template);
    }

    public static String showInputDialog(Stage owner, String message) {
        return Dialogs.showInputDialog(owner, message, "Masthead");
    }

    public static String showInputDialog(Stage owner, String message, String masthead) {
        return Dialogs.showInputDialog(owner, message, masthead, "Title");
    }

    public static String showInputDialog(Stage owner, String message, String masthead, String title) {
        return Dialogs.showInputDialog(owner, message, masthead, title, null);
    }

    public static String showInputDialog(Stage owner, String message, String masthead, String title, String initialValue) {
        return Dialogs.showInputDialog(owner, message, masthead, title, initialValue, (Validator)null);
    }

    public static <T> T showInputDialog(Stage owner, String message, String masthead, String title, T initialValue, T ... choices) {
        return Dialogs.showInputDialog(owner, message, masthead, title, initialValue, Arrays.asList(choices));
    }

    public static <T> T showInputDialog(Stage owner, String message, String masthead, String title, T initialValue, List<T> choices) {
        DialogTemplate<T> template = new DialogTemplate<T>(owner, title, masthead, null);
        template.setInputContent(message, initialValue, choices, null);
        return Dialogs.showUserInputDialog(template);
    }

    public static <T> T showInputDialog(Stage owner, String message, String masthead, String title, T initialValue, Validator inputValidator) {
        DialogTemplate<T> template = new DialogTemplate<T>(owner, title, masthead, null);
        template.setInputContent(message, initialValue, null, inputValidator);
        return Dialogs.showUserInputDialog(template);
    }

    public static DialogResponse showCustomInputDialog(Stage owner, String masthead, String title, Node node, BooleanProperty validProperty, String ... stylesheets) {
        DialogTemplate template = new DialogTemplate(owner, title, masthead, null);
        template.setCustomInputContent(node, validProperty);
        template.getDialog().getScene().getStylesheets().addAll((Object[])stylesheets);
        return Dialogs.showCustomInputDialog(template);
    }

    private static DialogResponse showSimpleContentDialog(Stage owner, String title, String masthead, String message, DialogType dialogType, DialogOptions options) {
        DialogTemplate template = new DialogTemplate(owner, title, masthead, options);
        template.setSimpleContent(message, dialogType);
        return Dialogs.showDialog(template);
    }

    private static DialogResponse showDialog(DialogTemplate template) {
        try {
            template.show();
            return template.getResponse();
        }
        catch (Throwable e) {
            return DialogResponse.CLOSED;
        }
    }

    private static <T> T showUserInputDialog(DialogTemplate<T> template) {
        template.show();
        if (template.getResponse() == DialogResponse.OK) {
            return template.getInputResponse();
        }
        return null;
    }

    private static DialogResponse showCustomInputDialog(DialogTemplate template) {
        template.show();
        return template.getResponse();
    }

    private Dialogs() {
    }
}

