/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.dialog;

import com.anahata.jfx.JfxUtils;
import com.anahata.jfx.dialog.AdvancedErrorDialog;
import com.anahata.jfx.dialog.DialogOptions;
import com.anahata.jfx.dialog.DialogResources;
import com.anahata.jfx.dialog.DialogResponse;
import com.anahata.jfx.dialog.DialogType;
import com.anahata.jfx.dialog.ExceptionDialog;
import com.anahata.jfx.dialog.FXDialog;
import com.anahata.jfx.dialog.UITextArea;
import com.anahata.jfx.message.JfxMessage;
import com.anahata.jfx.validator.Validator;
import com.anahata.util.error.ErrorDetail;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxBuilder;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextAreaBuilder;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DialogTemplate<T> {
    private static final Logger log = LoggerFactory.getLogger(DialogTemplate.class);
    static final int DIALOG_WIDTH = 516;
    private static int MAIN_TEXT_WIDTH = 400;
    private FXDialog dialog;
    private VBox contentPane;
    private DialogType dialogType = DialogType.INFORMATION;
    private final DialogOptions options;
    private DialogResponse userResponse = DialogResponse.CLOSED;
    private DialogStyle style;
    private T initialInputValue;
    private Validator inputValidator;
    private BooleanProperty inputValidProperty = new SimpleBooleanProperty(true);
    private List<T> inputChoices;
    private Property<T> userInputResponse;
    private String mastheadString;
    private BorderPane mastheadPanel;
    private ImageView mastheadIcon;
    private UITextArea mastheadTextArea;
    private Pane centerPanel;
    private String contentString = null;
    private ObservableList<Button> buttons;
    private static final String okBtnStr = "common.ok.btn";
    private static final String yesBtnStr = "common.yes.btn";
    private static final String noBtnStr = "common.no.btn";
    private static final String cancelBtnStr = "common.cancel.btn";
    private static final String detailBtnStr = "common.detail.button";
    private Throwable throwable = null;
    private ErrorDetail errorDetail;
    private static final String SECURITY_ALERT_HIGH = "security.alert.high.image";
    private static final String SECURITY_ALERT_LOW = "security.alert.low.image";
    private ImageView securityIcon;
    private String[] alertStrs;
    private String[] infoStrs;
    private TextArea errorDescriptionTextArea;
    private CheckBox sendScreenshotCheckBox;
    private Node centerNode;
    private BooleanProperty validProperty;

    DialogTemplate(Stage owner, String title, String masthead, DialogOptions options) {
        this.dialog = new FXDialog(title, (Window)owner, true);
        this.contentPane = new VBox();
        this.dialog.setContentPane((Pane)this.contentPane);
        this.mastheadString = masthead;
        this.options = options;
    }

    void setSimpleContent(String contentString, DialogType dialogType) {
        this.setSimpleContent(contentString, dialogType, null, true);
    }

    void setSimpleContent(String contentString, DialogType dialogType, String infoString, boolean useWarningIcon) {
        this.style = DialogStyle.SIMPLE;
        this.contentString = contentString;
        DialogType dialogType2 = this.dialogType = dialogType == null ? DialogType.WARNING : dialogType;
        if (infoString != null) {
            String[] strs = new String[]{infoString};
            if (useWarningIcon) {
                this.alertStrs = strs;
            } else {
                this.infoStrs = strs;
            }
        }
        this.contentPane.getChildren().add((Object)this.createMasthead());
        this.contentPane.getChildren().add((Object)this.createCenterPanel());
        Pane bottomPanel = this.createBottomPanel();
        if (bottomPanel != null) {
            this.contentPane.getChildren().add((Object)bottomPanel);
        }
        this.dialog.setResizable(false);
    }

    void setErrorContent(String contentString, Throwable throwable) {
        this.style = DialogStyle.ERROR;
        this.contentString = contentString;
        this.throwable = throwable;
        this.dialogType = DialogType.ERROR;
        this.contentPane.getChildren().add((Object)this.createMasthead());
        this.contentPane.getChildren().add((Object)this.createCenterPanel());
        Pane bottomPanel = this.createBottomPanel();
        if (bottomPanel != null && bottomPanel.getChildren().size() > 0) {
            this.contentPane.getChildren().add((Object)bottomPanel);
        }
        this.dialog.setResizable(false);
    }

    void setAdvancedErrorContent(String contentString, ErrorDetail errorDetail) {
        this.style = DialogStyle.ADVANCED_ERROR;
        this.contentString = contentString;
        this.errorDetail = errorDetail;
        this.dialogType = DialogType.ADVANCED_ERROR;
        this.contentPane.getChildren().add((Object)this.createMasthead());
        this.contentPane.getChildren().add((Object)this.createCenterPanel());
        Pane bottomPanel = this.createBottomPanel();
        if (bottomPanel != null && bottomPanel.getChildren().size() > 0) {
            this.contentPane.getChildren().add((Object)bottomPanel);
        }
        this.dialog.setResizable(false);
    }

    void setReportIssueContent(String contentString, ErrorDetail errorDetail) {
        this.style = DialogStyle.REPORT_ISSUE;
        this.contentString = contentString;
        this.errorDetail = errorDetail;
        this.dialogType = DialogType.REPORT_ISSUE;
        this.contentPane.getChildren().add((Object)this.createMasthead());
        this.contentPane.getChildren().add((Object)this.createCenterPanel());
        Pane bottomPanel = this.createBottomPanel();
        if (bottomPanel != null && bottomPanel.getChildren().size() > 0) {
            this.contentPane.getChildren().add((Object)bottomPanel);
        }
        this.dialog.setResizable(false);
    }

    void setInputContent(String message, T initialValue, List<T> choices, Validator validator) {
        this.style = DialogStyle.INPUT;
        this.contentString = message;
        this.initialInputValue = initialValue;
        this.inputChoices = choices;
        this.inputValidator = validator;
        this.contentPane.getChildren().add((Object)this.createMasthead());
        this.contentPane.getChildren().add((Object)this.createCenterPanel());
        Pane bottomPanel = this.createBottomPanel();
        if (bottomPanel != null) {
            this.contentPane.getChildren().add((Object)bottomPanel);
        }
        this.dialog.setResizable(false);
    }

    void setCustomInputContent(Node centerNode, BooleanProperty inputValidProperty) {
        this.style = DialogStyle.CUSTOM_INPUT;
        this.centerNode = centerNode;
        this.inputValidProperty = inputValidProperty;
        this.contentPane.getChildren().add((Object)this.createMasthead());
        this.contentPane.getChildren().add((Object)this.createCenterPanel());
        Pane bottomPanel = this.createBottomPanel();
        if (bottomPanel != null) {
            this.contentPane.getChildren().add((Object)bottomPanel);
        }
        this.dialog.setResizable(false);
    }

    public FXDialog getDialog() {
        return this.dialog;
    }

    public void show() {
        this.dialog.showAndWait();
    }

    public void hide() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                DialogTemplate.this.dialog.hide();
            }
        });
    }

    public DialogResponse getResponse() {
        return this.userResponse;
    }

    public T getInputResponse() {
        if (this.userInputResponse != null) {
            return (T)this.userInputResponse.getValue();
        }
        return null;
    }

    private Pane createMasthead() {
        this.mastheadPanel = new BorderPane();
        this.mastheadPanel.getStyleClass().add((Object)"top-panel");
        this.mastheadTextArea = new UITextArea(MAIN_TEXT_WIDTH);
        this.mastheadTextArea.getStyleClass().add((Object)"masthead-label-1");
        VBox mastheadVBox = new VBox();
        mastheadVBox.setAlignment(Pos.CENTER_LEFT);
        this.mastheadTextArea.setText(this.mastheadString);
        this.mastheadTextArea.setAlignment(Pos.CENTER_LEFT);
        mastheadVBox.getChildren().add((Object)this.mastheadTextArea);
        this.mastheadPanel.setLeft((Node)mastheadVBox);
        BorderPane.setAlignment((Node)mastheadVBox, (Pos)Pos.CENTER_LEFT);
        this.mastheadIcon = this.dialogType == null ? DialogResources.getIcon("java48.image") : this.dialogType.getImage();
        this.mastheadPanel.setRight((Node)this.mastheadIcon);
        return this.mastheadPanel;
    }

    private Pane createCenterPanel() {
        this.centerPanel = new VBox();
        this.centerPanel.getStyleClass().add((Object)"center-panel");
        BorderPane contentPanel = new BorderPane();
        contentPanel.getStyleClass().add((Object)"center-content-panel");
        VBox.setVgrow((Node)contentPanel, (Priority)Priority.ALWAYS);
        Node content = this.createCenterContent();
        if (content != null) {
            contentPanel.setCenter(content);
            contentPanel.setPadding(new Insets(0.0, 0.0, 12.0, 0.0));
        }
        FlowPane buttonsPanel = new FlowPane(6.0, 0.0){

            protected void layoutChildren() {
                Button btn;
                int i;
                double widest = 50.0;
                for (i = 0; i < DialogTemplate.this.buttons.size(); ++i) {
                    btn = (Button)DialogTemplate.this.buttons.get(i);
                    if (btn == null) continue;
                    widest = Math.max(widest, btn.prefWidth(-1.0));
                }
                for (i = 0; i < DialogTemplate.this.buttons.size(); ++i) {
                    btn = (Button)DialogTemplate.this.buttons.get(i);
                    if (btn == null) continue;
                    btn.setPrefWidth(btn.isVisible() ? widest : 0.0);
                }
                super.layoutChildren();
            }
        };
        buttonsPanel.getStyleClass().add((Object)"button-bar");
        buttonsPanel.getChildren().addAll(this.createButtons());
        if (contentPanel.getChildren().size() > 0) {
            this.centerPanel.getChildren().add((Object)contentPanel);
        }
        BorderPane bottomPanel = new BorderPane();
        bottomPanel.getStyleClass().add((Object)"center-bottom-panel");
        bottomPanel.setRight((Node)buttonsPanel);
        this.centerPanel.getChildren().add((Object)bottomPanel);
        return this.centerPanel;
    }

    private Node createCenterContent() {
        if (this.style == DialogStyle.SIMPLE || this.style == DialogStyle.ERROR) {
            if (this.contentString != null) {
                UITextArea ta = new UITextArea(this.contentString);
                ta.getStyleClass().add((Object)"center-content-area");
                ta.setAlignment(Pos.TOP_LEFT);
                return ta;
            }
        } else {
            if (this.style == DialogStyle.ADVANCED_ERROR) {
                this.errorDescriptionTextArea = ((TextAreaBuilder)((TextAreaBuilder)TextAreaBuilder.create().prefWidth(360.0)).prefHeight(100.0)).build();
                this.sendScreenshotCheckBox = ((CheckBoxBuilder)CheckBoxBuilder.create().text("Send a picture of the screen")).selected(this.errorDetail.isSendScreenshot()).build();
                VBox vbox = ((VBoxBuilder)VBoxBuilder.create().spacing(8.0).children(new Node[]{((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().prefWidth(360.0)).minHeight(Double.NEGATIVE_INFINITY)).minWidth(Double.NEGATIVE_INFINITY)).styleClass(new String[]{"center-content-area"})).alignment(Pos.TOP_LEFT)).wrapText(true)).text(this.contentString)).build(), ((LabelBuilder)LabelBuilder.create().text("Enter a description of your actions at the time of the error:")).build(), this.errorDescriptionTextArea, this.sendScreenshotCheckBox})).build();
                return vbox;
            }
            if (this.style == DialogStyle.REPORT_ISSUE) {
                this.errorDescriptionTextArea = ((TextAreaBuilder)((TextAreaBuilder)TextAreaBuilder.create().prefWidth(360.0)).prefHeight(100.0)).build();
                this.sendScreenshotCheckBox = ((CheckBoxBuilder)CheckBoxBuilder.create().text("Send a picture of the screen")).selected(this.errorDetail.isSendScreenshot()).build();
                VBox vbox = ((VBoxBuilder)VBoxBuilder.create().spacing(8.0).children(new Node[]{((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().prefWidth(360.0)).minHeight(Double.NEGATIVE_INFINITY)).minWidth(Double.NEGATIVE_INFINITY)).styleClass(new String[]{"center-content-area"})).alignment(Pos.TOP_LEFT)).wrapText(true)).text(this.contentString)).build(), ((LabelBuilder)LabelBuilder.create().text("Enter details of the issue you would like to report:")).build(), this.errorDescriptionTextArea, this.sendScreenshotCheckBox})).build();
                return vbox;
            }
            if (this.style == DialogStyle.INPUT) {
                ComboBox inputControl;
                this.userInputResponse = new SimpleObjectProperty();
                if (this.inputChoices == null || this.inputChoices.isEmpty()) {
                    final TextField textField = new TextField();
                    final Tooltip tooltip = new Tooltip();
                    tooltip.setAutoFix(true);
                    tooltip.setAutoHide(true);
                    if (this.inputValidator != null) {
                        textField.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

                            public void handle(KeyEvent t) {
                                if (t.getCharacter() != null) {
                                    for (char c : t.getCharacter().toCharArray()) {
                                        JfxMessage message = DialogTemplate.this.inputValidator.validateKeyTyped(c);
                                        if (message == null || !message.isWarnOrHigher()) continue;
                                        if (message.isErrorOrHigher()) {
                                            t.consume();
                                        }
                                        if (message.getMessage() == null) continue;
                                        tooltip.setText(message.getMessage());
                                        JfxUtils.showTooltipRightOfControl((Control)textField, tooltip);
                                    }
                                }
                            }
                        });
                        textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                            public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                                JfxMessage message = DialogTemplate.this.inputValidator.validateProgress(newValue);
                                DialogTemplate.this.inputValidProperty.setValue(Boolean.valueOf(message == null || !message.isErrorOrHigher()));
                                if (message != null && message.isWarnOrHigher()) {
                                    if (message.isErrorOrHigher()) {
                                        textField.setText(oldValue);
                                    }
                                    if (message.getMessage() != null) {
                                        tooltip.setText(message.getMessage());
                                        JfxUtils.showTooltipRightOfControl((Control)textField, tooltip);
                                    }
                                }
                            }
                        });
                        textField.addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)new EventHandler<MouseEvent>(){

                            public void handle(MouseEvent t) {
                                tooltip.hide();
                            }
                        });
                        textField.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                            public void handle(KeyEvent t) {
                                tooltip.hide();
                            }
                        });
                    }
                    this.userInputResponse.bind((ObservableValue)textField.textProperty());
                    textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent t) {
                            DialogTemplate.this.userResponse = DialogResponse.OK;
                            DialogTemplate.this.hide();
                        }
                    });
                    if (this.initialInputValue != null) {
                        textField.setText(this.initialInputValue.toString());
                    }
                    inputControl = textField;
                } else if (this.inputChoices.size() > 10) {
                    ComboBox comboBox = new ComboBox();
                    comboBox.getItems().addAll(this.inputChoices);
                    comboBox.getSelectionModel().select(this.initialInputValue);
                    this.userInputResponse.bind((ObservableValue)comboBox.valueProperty());
                    inputControl = comboBox;
                } else {
                    ChoiceBox choiceBox = new ChoiceBox();
                    choiceBox.getItems().addAll(this.inputChoices);
                    choiceBox.getSelectionModel().select(this.initialInputValue);
                    this.userInputResponse.bind((ObservableValue)choiceBox.valueProperty());
                    inputControl = choiceBox;
                }
                HBox hbox = new HBox(10.0);
                if (this.contentString != null && !this.contentString.isEmpty()) {
                    Label label = new Label(this.contentString);
                    hbox.getChildren().add((Object)label);
                }
                if (inputControl != null) {
                    hbox.getChildren().add((Object)inputControl);
                }
                return hbox;
            }
            if (this.style == DialogStyle.CUSTOM_INPUT) {
                return this.centerNode;
            }
        }
        return null;
    }

    private List<Button> createButtons() {
        this.buttons = FXCollections.observableArrayList();
        if (this.style == DialogStyle.INPUT || this.style == DialogStyle.CUSTOM_INPUT) {
            Button okButton = this.createButton(okBtnStr, DialogResponse.OK, true, false);
            if (this.inputValidProperty != null) {
                okButton.disableProperty().bind((ObservableValue)this.inputValidProperty.not());
            }
            this.buttons.addAll((Object[])new Button[]{okButton, this.createButton(cancelBtnStr, DialogResponse.CANCEL, false, true)});
        } else if (DialogType.ERROR == this.dialogType && this.throwable != null) {
            this.buttons.addAll((Object[])new Button[]{this.createButton(okBtnStr, DialogResponse.OK, true, false)});
            Button detailsBtn = new Button(detailBtnStr == null ? "" : DialogResources.getMessage(detailBtnStr));
            detailsBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ae) {
                    new ExceptionDialog(DialogTemplate.this.dialog, DialogTemplate.this.throwable).show();
                }
            });
            this.buttons.add((Object)detailsBtn);
        } else if (DialogType.ADVANCED_ERROR == this.dialogType && this.errorDetail != null) {
            this.buttons.addAll((Object[])new Button[]{this.createButton(okBtnStr, DialogResponse.OK, true, false)});
            Button detailsBtn = new Button(detailBtnStr == null ? "" : DialogResources.getMessage(detailBtnStr));
            detailsBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ae) {
                    DialogTemplate.this.populateErrorDetail();
                    new AdvancedErrorDialog(DialogTemplate.this.dialog, DialogTemplate.this.errorDetail).show();
                }
            });
            this.buttons.add((Object)detailsBtn);
        } else if (DialogType.REPORT_ISSUE == this.dialogType && this.errorDetail != null) {
            final Button okButton = this.createButton(okBtnStr, DialogResponse.OK, true, false);
            okButton.setDisable(true);
            this.buttons.add((Object)okButton);
            this.errorDescriptionTextArea.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
                    okButton.setDisable(StringUtils.isBlank((CharSequence)newValue));
                }
            });
            Button detailsBtn = new Button(detailBtnStr == null ? "" : DialogResources.getMessage(detailBtnStr));
            detailsBtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ae) {
                    DialogTemplate.this.populateErrorDetail();
                    new AdvancedErrorDialog(DialogTemplate.this.dialog, DialogTemplate.this.errorDetail).show();
                }
            });
            this.buttons.add((Object)detailsBtn);
            this.buttons.add((Object)this.createButton(cancelBtnStr, DialogResponse.CANCEL, false, true));
        } else if (this.options == DialogOptions.OK) {
            this.buttons.addAll((Object[])new Button[]{this.createButton(okBtnStr, DialogResponse.OK, true, false)});
        } else if (this.options == DialogOptions.OK_CANCEL) {
            this.buttons.addAll((Object[])new Button[]{this.createButton(okBtnStr, DialogResponse.OK, true, false), this.createButton(cancelBtnStr, DialogResponse.CANCEL, false, true)});
        } else if (this.options == DialogOptions.YES_NO) {
            this.buttons.addAll((Object[])new Button[]{this.createButton(yesBtnStr, DialogResponse.YES, true, false), this.createButton(noBtnStr, DialogResponse.NO, false, true)});
        } else if (this.options == DialogOptions.YES_NO_CANCEL) {
            this.buttons.addAll((Object[])new Button[]{this.createButton(yesBtnStr, DialogResponse.YES, true, false), this.createButton(noBtnStr, DialogResponse.NO, false, true), this.createButton(cancelBtnStr, DialogResponse.CANCEL, false, false)});
        }
        return this.buttons;
    }

    private Button createButton(String extLabel, final DialogResponse response, boolean isDefault, boolean isCancel) {
        Button btn = new Button(extLabel == null ? "" : DialogResources.getMessage(extLabel));
        btn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent ae) {
                DialogTemplate.this.userResponse = response;
                DialogTemplate.this.populateErrorDetail();
                DialogTemplate.this.hide();
            }
        });
        btn.setDefaultButton(isDefault);
        btn.setCancelButton(isCancel);
        return btn;
    }

    private Pane createBottomPanel() {
        if (this.alertStrs == null && this.infoStrs == null) {
            return null;
        }
        HBox bottomPanel = new HBox();
        bottomPanel.getStyleClass().add((Object)"bottom-panel");
        String imageFile = SECURITY_ALERT_HIGH;
        if (this.alertStrs == null || this.alertStrs.length == 0) {
            imageFile = SECURITY_ALERT_LOW;
        }
        this.securityIcon = DialogResources.getIcon(imageFile);
        bottomPanel.getChildren().add((Object)this.securityIcon);
        int textAreaWidth = 333;
        UITextArea bulletText = new UITextArea(textAreaWidth);
        bulletText.getStyleClass().add((Object)"bottom-text");
        if ((this.alertStrs == null || this.alertStrs.length == 0) && this.infoStrs != null && this.infoStrs.length != 0) {
            bulletText.setText(this.infoStrs[0] != null ? this.infoStrs[0] : " ");
        } else if (this.alertStrs != null && this.alertStrs.length != 0) {
            bulletText.setText(this.alertStrs[0] != null ? this.alertStrs[0] : " ");
        }
        bottomPanel.getChildren().add((Object)bulletText);
        return bottomPanel;
    }

    private void populateErrorDetail() {
        if ((DialogType.ADVANCED_ERROR == this.dialogType || DialogType.REPORT_ISSUE == this.dialogType) && this.errorDetail != null) {
            this.errorDetail.setUserComments(this.errorDescriptionTextArea.getText());
            this.errorDetail.setSendScreenshot(this.sendScreenshotCheckBox.isSelected());
        }
    }

    private static enum DialogStyle {
        SIMPLE,
        ERROR,
        ADVANCED_ERROR,
        REPORT_ISSUE,
        INPUT,
        CUSTOM_INPUT;

    }
}

