/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control.util;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class LayoutUtils {
    public static Bounds getNodeBoundsInPane(@NonNull Node node, @NonNull Pane pane) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (pane == null) {
            throw new NullPointerException("pane");
        }
        Pane currPane = node instanceof Pane ? (Pane)node : null;
        Bounds nodeBounds = node.getBoundsInParent();
        double x = nodeBounds.getMinX();
        double y = nodeBounds.getMinY();
        while (node.getParent() != null) {
            if ((node = node.getParent()) instanceof Pane) {
                currPane = (Pane)node;
            }
            if (currPane != null && currPane.equals(pane)) break;
            Bounds bounds = node.getBoundsInParent();
            x += bounds.getMinX();
            y += bounds.getMinY();
        }
        Validate.validState((currPane != null ? 1 : 0) != 0, (String)"Pane not found for node %s", (Object[])new Object[]{node});
        return new BoundingBox(x, y, nodeBounds.getWidth(), nodeBounds.getHeight());
    }

    public static void setWidth(Control control, double ... widths) {
        Validate.notNull((Object)widths);
        Validate.isTrue((widths.length >= 1 ? 1 : 0) != 0, (String)"Require at least one width", (Object[])new Object[0]);
        Validate.isTrue((widths.length <= 3 ? 1 : 0) != 0, (String)"Require no more than three widths", (Object[])new Object[0]);
        control.setPrefWidth(widths[0]);
        control.setMinWidth(widths.length >= 2 ? widths[1] : Double.NEGATIVE_INFINITY);
        control.setMaxWidth(widths.length >= 3 ? widths[2] : Double.NEGATIVE_INFINITY);
    }

    public static void setHeight(Control control, double ... heights) {
        Validate.notNull((Object)heights);
        Validate.isTrue((heights.length >= 1 ? 1 : 0) != 0, (String)"Require at least one height", (Object[])new Object[0]);
        Validate.isTrue((heights.length <= 3 ? 1 : 0) != 0, (String)"Require no more than three heights", (Object[])new Object[0]);
        control.setPrefHeight(heights[0]);
        control.setMinHeight(heights.length >= 2 ? heights[1] : Double.NEGATIVE_INFINITY);
        control.setMaxHeight(heights.length >= 3 ? heights[2] : Double.NEGATIVE_INFINITY);
    }

    public static void setWidth(Region region, double ... widths) {
        Validate.notNull((Object)widths);
        Validate.isTrue((widths.length >= 1 ? 1 : 0) != 0, (String)"Require at least one width", (Object[])new Object[0]);
        Validate.isTrue((widths.length <= 3 ? 1 : 0) != 0, (String)"Require no more than three widths", (Object[])new Object[0]);
        region.setPrefWidth(widths[0]);
        region.setMinWidth(widths.length >= 2 ? widths[1] : Double.NEGATIVE_INFINITY);
        region.setMaxWidth(widths.length >= 3 ? widths[2] : Double.NEGATIVE_INFINITY);
    }

    private LayoutUtils() {
    }
}

