/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCompleteComboBoxOld<T>
extends ComboBox<T> {
    private static final Logger log = LoggerFactory.getLogger(AutoCompleteComboBoxOld.class);
    private static final double PREF_HEIGHT = 21.0;
    private final List<T> unfilteredList = new ArrayList<T>();
    private BooleanProperty onlyAllowPredefinedItems = new SimpleBooleanProperty(true);

    public AutoCompleteComboBoxOld() {
        this.setPrefHeight(21.0);
        this.setEditable(true);
        this.addEventFilter(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.LEFT) {
                    AutoCompleteComboBoxOld.this.hide();
                    event.consume();
                }
                if (event.getCode() == KeyCode.RIGHT) {
                    AutoCompleteComboBoxOld.this.hide();
                    event.consume();
                }
                if (event.getCode() == KeyCode.UP || event.getCode() == KeyCode.DOWN) {
                    event.consume();
                }
            }
        });
        final KeyCombination keyCombination = KeyCombination.keyCombination((String)"Ctrl+A");
        this.getEditor().setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (keyCombination.match(event)) {
                    AutoCompleteComboBoxOld.this.getEditor().selectAll();
                    return;
                }
                KeyCode eventCode = event.getCode();
                if (!(eventCode.equals((Object)KeyCode.LEFT) || eventCode.equals((Object)KeyCode.RIGHT) || eventCode.equals((Object)KeyCode.ENTER))) {
                    AutoCompleteComboBoxOld.this.show();
                }
                if (!(eventCode.equals((Object)KeyCode.TAB) || eventCode.equals((Object)KeyCode.CONTROL) || eventCode.equals((Object)KeyCode.UP) || eventCode.equals((Object)KeyCode.DOWN))) {
                    AutoCompleteComboBoxOld.this.filterBasedOnString(AutoCompleteComboBoxOld.this.getEditor().getText());
                }
            }
        });
        this.setOnShown((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                int selectedIndex = AutoCompleteComboBoxOld.this.getSelectionModel().getSelectedIndex();
                ComboBoxListViewSkin skin = (ComboBoxListViewSkin)AutoCompleteComboBoxOld.this.getSkin();
                skin.getListView().scrollTo(selectedIndex < 0 ? 0 : selectedIndex);
            }
        });
    }

    public BooleanProperty onlyAllowPredefinedItemsProperty() {
        return this.onlyAllowPredefinedItems;
    }

    public void setOnlyAllowPredefinedItems(boolean onlyAllowPredefinedItems) {
        this.onlyAllowPredefinedItems.set(onlyAllowPredefinedItems);
    }

    public boolean isOnlyAllowPredefinedItems() {
        return this.onlyAllowPredefinedItems.get();
    }

    public void clearSelection() {
        super.getSelectionModel().clearSelection();
        super.getEditor().setText("");
        super.getEditor().clear();
    }

    public void clearItems() {
        this.unfilteredList.clear();
        super.getItems().clear();
    }

    public void setRecords(List<T> list) {
        this.unfilteredList.clear();
        this.unfilteredList.addAll(list);
        super.getItems().setAll(list);
    }

    protected void filterBasedOnString(String newval) {
        if (newval == null || newval.equals("")) {
            super.getItems().setAll(this.unfilteredList);
        } else {
            int caretPosition = super.getEditor().getCaretPosition();
            super.getItems().clear();
            for (T item : this.unfilteredList) {
                String[] splitted;
                String str = this.getConverter() == null ? item.toString().toLowerCase() : this.getConverter().toString(item).toLowerCase();
                boolean containsParts = true;
                for (String splitPart : splitted = newval.toLowerCase().split("\\s+")) {
                    if (splitPart.isEmpty() || str.contains(splitPart)) continue;
                    containsParts = false;
                }
                if (!containsParts) continue;
                super.getItems().add(item);
            }
            super.getEditor().setText(newval);
            super.getEditor().positionCaret(caretPosition);
        }
    }

    public List<T> getUnfilteredList() {
        return this.unfilteredList;
    }
}

