/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.message;

import org.apache.commons.lang3.Validate;

public class JfxMessage {
    private Severity severity;
    private String message;

    public static JfxMessage info(String message) {
        Validate.notNull((Object)message);
        return new JfxMessage(Severity.INFO, message);
    }

    public static JfxMessage warn(String message) {
        Validate.notNull((Object)message);
        return new JfxMessage(Severity.WARN, message);
    }

    public static JfxMessage error(String message) {
        Validate.notNull((Object)message);
        return new JfxMessage(Severity.ERROR, message);
    }

    public static JfxMessage fatal(String message) {
        Validate.notNull((Object)message);
        return new JfxMessage(Severity.FATAL, message);
    }

    public boolean isWarnOrHigher() {
        return this.severity.getLevel() >= 1;
    }

    public boolean isErrorOrHigher() {
        return this.severity.getLevel() >= 2;
    }

    private JfxMessage(Severity severity, String message) {
        this.severity = severity;
        this.message = message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JfxMessage)) {
            return false;
        }
        JfxMessage other = (JfxMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Severity this$severity = this.getSeverity();
        Severity other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !((Object)((Object)this$severity)).equals((Object)other$severity)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JfxMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Severity $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 0 : ((Object)((Object)$severity)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 0 : $message.hashCode());
        return result;
    }

    public static enum Severity {
        INFO(0),
        WARN(1),
        ERROR(2),
        FATAL(3);

        private int level;

        private Severity(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

