/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.nodemodel;

import com.anahata.jfx.bind.nodemodel.InitializableNodeModel;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import org.apache.commons.lang3.Validate;

public class ToggleGroupNodeModel
implements InitializableNodeModel<ToggleGroup, ObjectProperty> {
    private final Map<Object, Toggle> toggles = new HashMap<Object, Toggle>();
    private final ObjectProperty value = new SimpleObjectProperty();
    private boolean block = false;
    private ToggleGroup toggleGroup;

    @Override
    public ObjectProperty getNodeModelValueProperty(ToggleGroup node) {
        return this.value;
    }

    @Override
    public void setNode(ToggleGroup tg) {
        Validate.notNull((Object)tg);
        this.toggleGroup = tg;
        for (Toggle toggle : this.toggleGroup.getToggles()) {
            Validate.notNull((Object)toggle.getUserData(), (String)"userData not set for toggle %s", (Object[])new Object[]{toggle});
            this.toggles.put(toggle.getUserData(), toggle);
        }
        this.toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle oldValue, Toggle newValue) {
                ToggleGroupNodeModel.this.block = true;
                ToggleGroupNodeModel.this.value.set(newValue.getUserData());
                ToggleGroupNodeModel.this.block = false;
            }
        });
        this.value.addListener(new ChangeListener(){

            public void changed(ObservableValue ov, Object oldValue, Object newValue) {
                if (ToggleGroupNodeModel.this.block) {
                    return;
                }
                Toggle toggle = (Toggle)ToggleGroupNodeModel.this.toggles.get(newValue);
                Validate.validState((toggle != null ? 1 : 0) != 0, (String)"Could not find toggle for value %s", (Object[])new Object[]{newValue});
                ToggleGroupNodeModel.this.toggleGroup.selectToggle(toggle);
            }
        });
    }
}

