/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind.converter;

import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.converter.string.BigDecimalConverter;
import com.anahata.jfx.bind.converter.string.DoubleConverter;
import com.anahata.jfx.bind.converter.string.IntegerConverter;
import com.anahata.jfx.bind.converter.string.LongConverter;
import com.anahata.jfx.bind.converter.string.NullEmptyStringConverter;
import com.anahata.util.reflect.ReflectionUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;

public class ConverterFactory {
    private static final List<? extends Converter> DEFAULT_CONVERTERS = Arrays.asList(NullEmptyStringConverter.INSTANCE, LongConverter.INSTANCE, DoubleConverter.INSTANCE, IntegerConverter.INSTANCE, BigDecimalConverter.INSTANCE);
    private static final Map<Class, Map<Class, Converter>> CONVERTERS = new HashMap<Class, Map<Class, Converter>>();

    public static void addConverter(Converter converter) {
        Class[] types = ReflectionUtils.getGenericArgs(Converter.class, converter.getClass());
        if (types != null) {
            Map<Class, Converter> convs = CONVERTERS.get(types[0]);
            if (convs == null) {
                convs = new HashMap<Class, Converter>();
                CONVERTERS.put(types[0], convs);
            }
            convs.put(types[1], converter);
        }
    }

    public static Converter getDefaultConverter(Class domainModelType, Class nodeModelType) {
        Validate.notNull((Object)domainModelType);
        Validate.notNull((Object)nodeModelType);
        domainModelType = ClassUtils.primitiveToWrapper((Class)domainModelType);
        nodeModelType = ClassUtils.primitiveToWrapper((Class)nodeModelType);
        Map<Class, Converter> convs = CONVERTERS.get(domainModelType);
        if (convs != null) {
            return convs.get(nodeModelType);
        }
        return null;
    }

    public static void validateConverter(Converter converter, Class domainModelType, Class nodeModelType) {
        Validate.notNull((Object)converter);
        Validate.notNull((Object)domainModelType);
        Validate.notNull((Object)nodeModelType);
        Class[] types = ReflectionUtils.getGenericArgs(Converter.class, converter.getClass());
        Validate.isTrue((types != null ? 1 : 0) != 0, (String)"Converter invalid, could not obtain generic types", (Object[])new Object[0]);
        Validate.isTrue((boolean)domainModelType.equals(types[0]), (String)"The domain model type doesn't match, converter is %s, arg is %s", (Object[])new Object[]{types[0].getSimpleName(), domainModelType.getSimpleName()});
        Validate.isTrue((boolean)nodeModelType.equals(types[1]), (String)"The node model type doesn't match, converter is %s, arg is %s", (Object[])new Object[]{types[1].getSimpleName(), nodeModelType.getSimpleName()});
    }

    private ConverterFactory() {
    }

    static {
        for (Converter converter : DEFAULT_CONVERTERS) {
            ConverterFactory.addConverter(converter);
        }
    }
}

