/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.layer;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.lodgon.openmapfx.core.LayeredMap;
import org.lodgon.openmapfx.core.MapLayer;

public class PositionLayer
extends Parent
implements MapLayer {
    private double lat;
    private double lon;
    private final Node icon;
    private final double iconTranslateX;
    private final double iconTranslateY;
    private LayeredMap layeredMap;

    public PositionLayer(Image image) {
        this((Node)new ImageView(image), image.getWidth() / -2.0, image.getHeight() / -2.0);
    }

    public PositionLayer(Node icon) {
        this(icon, 0.0, 0.0);
    }

    public PositionLayer(Node icon, double translateX, double translateY) {
        this.icon = icon;
        this.icon.setVisible(false);
        this.iconTranslateX = translateX;
        this.iconTranslateY = translateY;
        this.getChildren().add((Object)icon);
    }

    @Override
    public Node getView() {
        return this;
    }

    public void updatePosition(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        this.refreshLayer();
    }

    protected void refreshLayer() {
        Point2D cartPoint = this.layeredMap.getMapPoint(this.lat, this.lon);
        if (cartPoint == null) {
            System.out.println("[JVDBG] Null cartpoint, probably no scene, dont show.");
            return;
        }
        this.icon.setVisible(true);
        this.icon.setTranslateX(cartPoint.getX() + this.iconTranslateX);
        this.icon.setTranslateY(cartPoint.getY() + this.iconTranslateY);
    }

    @Override
    public void gotLayeredMap(LayeredMap map) {
        this.layeredMap = map;
        this.layeredMap.zoomProperty().addListener(e -> this.refreshLayer());
        this.layeredMap.centerLatitudeProperty().addListener(e -> this.refreshLayer());
        this.layeredMap.centerLongitudeProperty().addListener(e -> this.refreshLayer());
        this.layeredMap.xShiftProperty().addListener(e -> this.refreshLayer());
        this.layeredMap.yShiftProperty().addListener(e -> this.refreshLayer());
        this.refreshLayer();
    }
}

