/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.concurrent;

import com.anahata.jfx.concurrent.ApplicationTask;
import com.anahata.jfx.concurrent.BackgroundTaskCancelledException;
import com.anahata.util.formatting.Displayable;
import com.anahata.util.progress.ProgressMessage;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BackgroundInvocationHandler.class);
    protected Node nodeToDisable;
    protected BooleanProperty runningProperty = new SimpleBooleanProperty();
    protected Object delegate;

    public static void disableWhileRunning(Node node, Object ... proxies) {
        for (Object remoteService : proxies) {
            ((BackgroundInvocationHandler)Proxy.getInvocationHandler(remoteService)).setNodeToDisable(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        log.debug("method {} ", (Object)method);
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        if (Platform.isFxApplicationThread()) {
            Object returnObj;
            final Object key = new Object();
            ApplicationTask applicationTask = new ApplicationTask(){

                protected Object call() throws Exception {
                    Object arg;
                    log.trace("ApplicationTask cal() starts {} ", (Object)method);
                    String title = "Processing";
                    if (method.isAnnotationPresent(ProgressMessage.class)) {
                        title = method.getAnnotation(ProgressMessage.class).value();
                    }
                    String message = method.getDeclaringClass().getSimpleName() + " " + method.getName();
                    if (args != null && args.length > 0 && (arg = args[0]) instanceof Displayable) {
                        try {
                            message = message + " " + ((Displayable)arg).getDisplayValue();
                        }
                        catch (Exception e) {
                            log.warn("Could not call getDisplayValue on parameter 0 of " + title + " " + message, (Throwable)e);
                        }
                    }
                    this.updateTitle(title);
                    this.updateMessage(message);
                    Object ret = method.invoke(BackgroundInvocationHandler.this.delegate, args);
                    log.trace("ApplicationTask cal() finished {} ", (Object)method);
                    return ret;
                }

                protected void succeeded() {
                    log.trace("ApplicationTask suceeded(). exitingNestedEventLoop {} ", (Object)method);
                    Toolkit.getToolkit().exitNestedEventLoop(key, super.getValue());
                }

                @Override
                protected void cancelled() {
                    super.cancelled();
                    log.debug("ApplicationTask cancelled() exitingNestedEventLoop {} ", (Object)method);
                    Toolkit.getToolkit().exitNestedEventLoop(key, (Object)new BackgroundTaskCancelledException());
                }

                protected void failed() {
                    super.failed();
                    log.debug("ApplicationTask failed() exitingNestedEventLoop {}", (Object)method);
                    Toolkit.getToolkit().exitNestedEventLoop(key, (Object)super.getException());
                }
            };
            if (this.runningProperty != null) {
                this.runningProperty.unbind();
                this.runningProperty.bind((ObservableValue)applicationTask.runningProperty());
            }
            if (this.nodeToDisable != null) {
                this.nodeToDisable.disableProperty().unbind();
                this.nodeToDisable.disableProperty().bind((ObservableValue)applicationTask.runningProperty());
            }
            long ts = System.currentTimeMillis();
            log.trace("Calling ApplicationTask.launch() {} ", (Object)method);
            applicationTask.launch();
            try {
                log.trace("entering nested event loop() {} ", (Object)method);
                returnObj = Toolkit.getToolkit().enterNestedEventLoop(key);
            }
            catch (IllegalStateException e) {
                String msg = "Exceptiong attempting to enter the nested event loop to process the call in @Background. Talk to Pablo or Goran to figure out why this is happening. Known reasons are that the background annotation is called from within a TimeLine or triggered by a value change in CalendarTextField. The call will be ran in the JavaFX thread but please look into the problem. A known workaround is to do Platform.runLater.";
                log.error(msg, (Throwable)e);
                returnObj = method.invoke(this.delegate, args);
            }
            finally {
                ts = System.currentTimeMillis() - ts;
                log.trace("ApplicationTask exited nestedEventLoop in {} {} ", (Object)ts, (Object)method);
            }
            if (returnObj instanceof Throwable) {
                throw (Throwable)returnObj;
            }
            return returnObj;
        }
        return method.invoke(this.delegate, args);
    }

    public static <T> T newAsynchProxy(T delegate, Node node, BooleanProperty running) {
        BackgroundInvocationHandler proxy = new BackgroundInvocationHandler();
        proxy.setDelegate(delegate);
        proxy.setNodeToDisable(node);
        if (running != null) {
            proxy.setRunningProperty(running);
        }
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), ClassUtils.getAllInterfaces(delegate.getClass()).toArray(new Class[0]), (InvocationHandler)proxy);
    }

    public void setNodeToDisable(Node nodeToDisable) {
        this.nodeToDisable = nodeToDisable;
    }

    public void setRunningProperty(BooleanProperty runningProperty) {
        this.runningProperty = runningProperty;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }
}

