/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.binding;

import java.util.Arrays;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabPaneUtils {
    private static final Logger log = LoggerFactory.getLogger(TabPaneUtils.class);
    private static final String TAB_INDEX = "tab-index";

    public static void bindVisibleTabs(ObservableBooleanValue value, TabPane tabPane, Tab ... tabs) {
        value.addListener((InvalidationListener)new TabVisibleListener(value, tabPane, tabs));
    }

    static class TabVisibleListener
    implements InvalidationListener {
        private final TabPane tabPane;
        private final List<Tab> tabs;
        private final List<Tab> allTabs;
        private final ObservableBooleanValue value;

        public TabVisibleListener(ObservableBooleanValue value, TabPane tabPane, Tab ... tabs) {
            Validate.notNull((Object)tabPane);
            Validate.noNullElements((Object[])tabs);
            this.tabPane = tabPane;
            this.tabs = Arrays.asList(tabs);
            this.value = value;
            this.allTabs = tabPane.getTabs();
            this.init();
        }

        private void init() {
            this.buildMapper();
            this.showHideTabs();
        }

        private void showHideTabs() {
            for (Tab tab : this.tabs) {
                if (!this.value.get() || this.tabPane.getTabs().contains((Object)tab)) continue;
                int index = (Integer)tab.getProperties().get((Object)TabPaneUtils.TAB_INDEX);
                log.debug("index= {} tab= \"{}\" tabPane= {}", new Object[]{index, tab.getText(), this.tabPane});
                if (index == -1) continue;
                log.debug("adding tab \"{}\" at index {} to tabPane {}", new Object[]{tab.getText(), index, this.tabPane});
                this.tabPane.getTabs().add(index, (Object)tab);
            }
            for (Tab tab : this.tabs) {
                if (this.value.get()) continue;
                log.debug("--removing tab \"{}\" from tabPane {}", (Object)tab.getText(), (Object)this.tabPane);
                this.tabPane.getTabs().remove((Object)tab);
            }
        }

        private void buildMapper() {
            log.debug("building mapper.");
            for (Tab tab : this.allTabs) {
                tab.getProperties().put((Object)TabPaneUtils.TAB_INDEX, (Object)this.tabPane.getTabs().indexOf((Object)tab));
            }
        }

        public void invalidated(Observable o) {
            log.debug("value= {}", (Object)this.value);
            this.showHideTabs();
        }
    }
}

