/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.layout;

import com.anahata.jfx.JfxUtils;
import com.anahata.jfx.layout.ControlledScreen;
import com.anahata.jfx.layout.SceneFactory;
import com.anahata.jfx.navigation.NavigationConfirmation;
import com.anahata.util.cdi.Cdi;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreensController
extends StackPane {
    private static final Logger log = LoggerFactory.getLogger(ScreensController.class);
    private Map<String, ScreenInfo> screens = new HashMap<String, ScreenInfo>();
    private ScreenInfo current;
    private ScreensController parentScreensController;

    public ScreensController() {
    }

    public ScreensController(ScreensController source) {
        for (Map.Entry<String, ScreenInfo> entry : source.screens.entrySet()) {
            ScreenInfo clone = entry.getValue().clone(this);
            this.screens.put(entry.getKey(), clone);
        }
    }

    public void reload() {
        String currentId = this.current.screenName;
        this.getChildren().clear();
        for (ScreenInfo si : this.screens.values()) {
            si.unload();
        }
        this.navigate(currentId);
    }

    public void preload(String ... screenNames) {
        long ts = System.currentTimeMillis();
        for (String si : screenNames) {
            this.screens.get(si).load();
        }
        ts = System.currentTimeMillis() - ts;
        log.debug("preload took {} ms to load {} screens", (Object)ts, (Object)screenNames.length);
    }

    public void preloadAll() {
        long ts = System.currentTimeMillis();
        for (ScreenInfo si : this.screens.values()) {
            si.load();
        }
        ts = System.currentTimeMillis() - ts;
        log.debug("preloadAll took {} ms to load {} screens", (Object)ts, this.screens.values());
    }

    public void addScreen(String screenName, String fxml) {
        ScreenInfo sci = new ScreenInfo(this, screenName, fxml, null, null, false);
        this.screens.put(screenName, sci);
    }

    public <T> T getController(String screenName) {
        ScreenInfo info = this.screens.get(screenName);
        return info == null ? null : (T)info.getController();
    }

    public boolean isScreenRegistered(String screenName) {
        return this.screens.get(screenName) != null;
    }

    public DialogContext newDialog(Stage owner, String screenName, String title, double width) {
        DialogContext info = new DialogContext(owner, this, screenName, title, width, null, true);
        return info;
    }

    public DialogContext newDialog(Stage owner, String screenName, String title, double width, boolean modal) {
        DialogContext info = new DialogContext(owner, this, screenName, title, width, null, modal);
        return info;
    }

    public DialogContext newDialog(Stage owner, String screenName, String title, double width, double height) {
        DialogContext info = new DialogContext(owner, this, screenName, title, width, height, true);
        return info;
    }

    public DialogContext newDialog(String screenName, String title, double width) {
        DialogContext info = new DialogContext(this.getCurrentStage(), this, screenName, title, width, null, true);
        return info;
    }

    public DialogContext newDialog(String screenName, String title, double width, boolean modal) {
        DialogContext info = new DialogContext(this.getCurrentStage(), this, screenName, title, width, null, modal);
        return info;
    }

    public DialogContext newDialog(String screenName, String title, double width, double height) {
        DialogContext info = new DialogContext(this.getCurrentStage(), this, screenName, title, width, height, true);
        return info;
    }

    public DialogContext newDialog(String screenName, String title, double width, double height, boolean modal) {
        DialogContext info = new DialogContext(this.getCurrentStage(), this, screenName, title, width, height, modal);
        return info;
    }

    public Stage getCurrentStage() {
        return JfxUtils.getStage(this.getCurrent().getNode());
    }

    public ScreenInfo navigate(String name) {
        long ts = System.currentTimeMillis();
        String currentName = this.current != null ? this.current.getScreenName() : " ";
        log.debug("Navigating to: {}, current ={}", (Object)name, (Object)currentName);
        ScreenInfo requested = this.screens.get(name);
        if (requested != null) {
            if (this.current != null) {
                if (!this.canNavigate()) {
                    return null;
                }
                this.current.getController().onDeparture();
                this.current.getNode().setVisible(false);
            }
            if (!this.getChildren().contains((Object)requested.getNode())) {
                this.getChildren().add((Object)requested.getNode());
            }
        } else {
            throw new IllegalArgumentException("Could not navigate to screen " + name);
        }
        requested.getNode().setVisible(true);
        this.current = requested;
        requested.getController().onArrival();
        ts = System.currentTimeMillis() - ts;
        log.trace("Navigating from {} to: {}, took {} ms.", new Object[]{currentName, currentName, ts});
        return requested;
    }

    public boolean unloadScreen(String name) {
        ScreenInfo si = this.screens.remove(name);
        if (si == null) {
            return false;
        }
        this.getChildren().remove((Object)si.getNode());
        return true;
    }

    public boolean isDialog() {
        return this.current.dialogInfo != null;
    }

    public boolean canNavigate() {
        if (this.current == null) {
            return true;
        }
        if (this.current.getController() instanceof NavigationConfirmation) {
            NavigationConfirmation nc = (NavigationConfirmation)this.current.getController();
            return nc.canNavigateAway();
        }
        return true;
    }

    public void closeDialog() {
        if (this.isDialog()) {
            this.current.dialogInfo.stage.close();
        } else {
            log.debug("Not in dialog");
        }
    }

    public ScreenInfo getCurrent() {
        return this.current;
    }

    public class DialogContext {
        private Stage stage;
        private final ScreenInfo screenInfo;

        public DialogContext(Stage owner, ScreensController parent, String screenName, String screenTitle, Double width, Double height, boolean modal) {
            ScreensController.this.parentScreensController = parent;
            ScreensController screensController = new ScreensController(parent);
            this.screenInfo = (ScreenInfo)screensController.screens.get(screenName);
            this.screenInfo.load();
            this.screenInfo.dialogInfo = this;
            screensController.current = this.screenInfo;
            this.stage = new Stage();
            this.stage.setResizable(true);
            this.stage.setTitle(screenTitle);
            if (owner == null) {
                this.stage.centerOnScreen();
            } else {
                this.stage.setX(owner.getX() + 20.0);
                this.stage.setY(owner.getY() + 20.0);
            }
            if (width != null) {
                this.stage.setWidth(width.doubleValue());
            }
            if (height != null) {
                this.stage.setHeight(height.doubleValue());
            }
            if (modal) {
                this.stage.initModality(Modality.APPLICATION_MODAL);
            } else {
                this.stage.initModality(Modality.NONE);
            }
            SceneFactory sceneFactory = (SceneFactory)Cdi.get(SceneFactory.class, (Annotation[])new Annotation[0]);
            AnchorPane ap = new AnchorPane();
            ap.getChildren().add((Object)this.screenInfo.node);
            AnchorPane.setBottomAnchor((Node)this.screenInfo.node, (Double)0.0);
            AnchorPane.setTopAnchor((Node)this.screenInfo.node, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)this.screenInfo.node, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.screenInfo.node, (Double)0.0);
            Scene scene = sceneFactory.newScene((Parent)ap);
            this.stage.setScene(scene);
        }

        public void showAndWait() {
            this.stage.showAndWait();
        }

        public void show() {
            this.stage.show();
        }

        @ConstructorProperties(value={"stage", "screenInfo"})
        public DialogContext(Stage stage, ScreenInfo screenInfo) {
            this.stage = stage;
            this.screenInfo = screenInfo;
        }

        public Stage getStage() {
            return this.stage;
        }

        public <T extends ControlledScreen> T getController() {
            return this.screenInfo.getController();
        }

        public Node getNode() {
            return this.screenInfo.getNode();
        }

        public ScreenInfo clone(ScreensController screensController) {
            return this.screenInfo.clone(screensController);
        }

        public void unload() {
            this.screenInfo.unload();
        }

        public String getScreenName() {
            return this.screenInfo.getScreenName();
        }

        public String getFxmlFile() {
            return this.screenInfo.getFxmlFile();
        }
    }

    public static class ScreenInfo {
        private String screenName;
        private String fxmlFile;
        private Node node;
        private ControlledScreen controller;
        private boolean loaded;
        private ScreensController screensController;
        private DialogContext dialogInfo;

        public ScreenInfo(ScreensController screensController, String screenName, String fxmlFile, Node node, ControlledScreen controller, boolean loaded) {
            this.screensController = screensController;
            this.screenName = screenName;
            this.fxmlFile = fxmlFile;
            this.node = node;
            this.controller = controller;
            this.loaded = loaded;
        }

        public <T extends ControlledScreen> T getController() {
            this.load();
            log.debug("controller is= {}", (Object)this.controller);
            return (T)this.controller;
        }

        public Node getNode() {
            this.load();
            return this.node;
        }

        public ScreenInfo clone(ScreensController screensController) {
            return new ScreenInfo(screensController, this.screenName, this.fxmlFile, null, null, false);
        }

        public void unload() {
            if (!this.loaded) {
                return;
            }
            this.node = null;
            this.controller = null;
            this.loaded = false;
        }

        private void load() {
            if (this.loaded) {
                return;
            }
            long ts = System.currentTimeMillis();
            log.debug("Loading {}", (Object)this.fxmlFile);
            FXMLLoader loader = JfxUtils.load(this.fxmlFile);
            this.node = (Node)loader.getRoot();
            ControlledScreen cs = (ControlledScreen)loader.getController();
            cs.setScreensController(this.screensController);
            this.controller = cs;
            this.loaded = true;
            ts = System.currentTimeMillis() - ts;
            log.debug("Loading {} took {} ms", (Object)this.fxmlFile, (Object)ts);
        }

        public String getScreenName() {
            return this.screenName;
        }

        public String getFxmlFile() {
            return this.fxmlFile;
        }
    }
}

