/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.concurrent;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.progress.ProgressListener;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationTask<T>
extends Task<T>
implements EventHandler,
ProgressListener {
    private static final Logger log = LoggerFactory.getLogger(ApplicationTask.class);
    private static ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        volatile int threadCount = 1;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("ApplicationTask Thread " + this.threadCount++);
            t.setDaemon(true);
            return t;
        }
    });
    private VBox mainVbox;

    public ApplicationTask() {
        super.setOnScheduled(new EventHandler(){

            public void handle(Event t) {
                log.trace("{} scheduled", (Object)ApplicationTask.this.getTitle());
                ChangeListener<Object> updateMainAppListener = new ChangeListener<Object>(){

                    public void changed(ObservableValue<? extends Object> ov, Object t, Object t1) {
                        Cdi.fireEvent((Object)((Object)ApplicationTask.this), (Annotation[])new Annotation[0]);
                    }
                };
                ApplicationTask.this.titleProperty().addListener((ChangeListener)updateMainAppListener);
                ApplicationTask.this.messageProperty().addListener((ChangeListener)updateMainAppListener);
                ApplicationTask.this.runningProperty().addListener((ChangeListener)updateMainAppListener);
                ApplicationTask.this.exceptionProperty().addListener((ChangeListener)updateMainAppListener);
                ApplicationTask.this.updateProgress(-1L, -1L);
                Cdi.fireEvent((Object)((Object)ApplicationTask.this), (Annotation[])new Annotation[0]);
            }
        });
        super.setOnFailed(new EventHandler(){

            public void handle(Event t) {
                Throwable throwable = ApplicationTask.this.getException();
                log.error(ApplicationTask.this.getTitle() + " failed", throwable);
            }
        });
    }

    protected void cancelled() {
        log.debug("Applicaiton Task {} calling interrupt on {}", (Object)this.getTitle(), (Object)Thread.currentThread().getName());
        Thread.currentThread().interrupt();
    }

    public void handle(Event t) {
        this.launch();
    }

    public void launch() {
        threadPool.submit((Runnable)((Object)this));
    }

    public void delayedLaunch(final long delay) {
        threadPool.submit(new Runnable(){

            @Override
            public void run() {
                log.debug("launching with delay will sleep for {} ms", (Object)delay);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.debug("launching with delay woke up after {} ms, launching {}", (Object)delay);
                threadPool.submit((Runnable)((Object)ApplicationTask.this));
            }
        });
    }

    public VBox getComponent() {
        Validate.isTrue((boolean)Platform.isFxApplicationThread(), (String)"getComponent() can only run inside FX thread", (Object[])new Object[0]);
        if (this.mainVbox == null) {
            this.mainVbox = new VBox();
            Label titleLabel = new Label();
            ProgressBar pb = new ProgressBar();
            ImageView cancelIcon = new ImageView(new Image("/img/yam/action/delete_16.png"));
            Button cancelButton = new Button(null, (Node)cancelIcon);
            cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    ApplicationTask.this.cancel(true);
                }
            });
            Label messageLabel = new Label();
            cancelButton.setTooltip(new Tooltip("Cancel"));
            HBox titleAndCancel = new HBox();
            HBox titleWrapper = new HBox();
            titleWrapper.getChildren().add((Object)titleLabel);
            titleAndCancel.getChildren().addAll((Object[])new Node[]{titleWrapper, cancelButton});
            HBox.setHgrow((Node)titleWrapper, (Priority)Priority.ALWAYS);
            this.mainVbox.getChildren().add((Object)titleAndCancel);
            this.mainVbox.getChildren().add((Object)pb);
            this.mainVbox.getChildren().add((Object)messageLabel);
            messageLabel.getStyleClass().add((Object)"applicationTaskMessage");
            titleLabel.getStyleClass().add((Object)"applicationTaskTitle");
            titleLabel.textProperty().bind((ObservableValue)this.titleProperty());
            messageLabel.textProperty().bind((ObservableValue)this.messageProperty());
            pb.progressProperty().bind((ObservableValue)this.progressProperty());
            pb.prefWidthProperty().bind((ObservableValue)this.mainVbox.widthProperty().subtract(5));
        }
        return this.mainVbox;
    }

    public void progress(double progress) {
        if (progress <= 1.0) {
            this.updateProgress(progress, 1.0);
        } else {
            this.updateProgress(-1L, 1L);
        }
    }
}

