/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind2;

import com.anahata.jfx.bind.converter.Converter;
import com.anahata.jfx.bind.filter.KeystrokeFilter;
import com.anahata.jfx.bind2.BindField;
import com.anahata.jfx.validator.FieldValidator;
import com.anahata.util.validation.ValidationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindForm {
    private static final Logger log = LoggerFactory.getLogger(BindForm.class);
    private static final Logger vlog = LoggerFactory.getLogger((String)(BindForm.class.getName() + "#validate"));
    private final Object formNode;
    private final Map<String, ObjectProperty<?>> models = new HashMap();
    private final Map<String, Map<String, BindField>> modelFields = new HashMap<String, Map<String, BindField>>();
    private final Validator validator;
    private final BooleanProperty valid = new SimpleBooleanProperty();
    private final BooleanProperty modified = new SimpleBooleanProperty();
    private boolean blocked = false;
    private boolean binding = false;

    public BindForm(@NonNull Object node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        this.formNode = node;
        this.validator = Validation.buildDefaultValidatorFactory().getValidator();
    }

    public void addModel(@NonNull String modelId, @NonNull ObjectProperty<?> model, boolean autoBind) {
        if (modelId == null) {
            throw new NullPointerException("modelId");
        }
        if (model == null) {
            throw new NullPointerException("model");
        }
        Validate.isTrue((!this.models.containsKey(modelId) ? 1 : 0) != 0, (String)"Model with id %s already added", (Object[])new Object[]{modelId});
        this.models.put(modelId, model);
        HashMap fieldMap = new HashMap();
        this.modelFields.put(modelId, fieldMap);
        if (autoBind) {
            model.addListener(new InvalidationListener(){

                public void invalidated(Observable o) {
                    BindForm.this.bindFromModel();
                }
            });
        }
    }

    public void addField(@NonNull String modelId, @NonNull Object node, @NonNull String propName, Converter converter, FieldValidator fieldValidator, KeystrokeFilter keystrokeFilter) {
        if (modelId == null) {
            throw new NullPointerException("modelId");
        }
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (propName == null) {
            throw new NullPointerException("propName");
        }
        Validate.isTrue((boolean)this.models.containsKey(modelId), (String)"Model with id %s has not been added", (Object[])new Object[]{modelId});
        ObjectProperty<?> model = this.models.get(modelId);
        BindField field = new BindField(modelId, this, model, propName, node, null, converter, fieldValidator, keystrokeFilter);
        Map<String, BindField> fieldMap = this.modelFields.get(modelId);
        fieldMap.put(propName, field);
    }

    public void bindFromModel() {
        if (this.blocked) {
            return;
        }
        this.notifyModelUpdated(null);
    }

    void notifyModelUpdated(BindField source) {
        if (this.blocked) {
            return;
        }
        this.binding = true;
        for (Map<String, BindField> fieldMap : this.modelFields.values()) {
            for (BindField field : fieldMap.values()) {
                if (source != null && field.equals(source)) continue;
                field.setNodeValue();
            }
        }
        this.binding = false;
        this.validate();
    }

    void validate() {
        if (this.blocked) {
            return;
        }
        for (Map.Entry<String, ObjectProperty<?>> entry : this.models.entrySet()) {
            Set violations;
            Object model = entry.getValue().getValue();
            if (model == null || (violations = this.validator.validate(model, new Class[0])).isEmpty()) continue;
            String modelId = entry.getKey();
            Map<String, BindField> fields = this.modelFields.get(modelId);
            for (ConstraintViolation violation : violations) {
                String propName = ValidationUtils.getValidationPropertyName((ConstraintViolation)violation, (boolean)true);
                if (!fields.containsKey(propName)) continue;
                vlog.debug("Validation error: model=[{}] field=[{}] message=[{}] => value=[{}]", new Object[]{modelId, model.getClass().getSimpleName() + "." + propName, violation.getMessage(), violation.getInvalidValue()});
            }
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    boolean isBinding() {
        return this.binding;
    }

    void setBinding(boolean binding) {
        this.binding = binding;
    }
}

