/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.ValidationStatus;
import com.anahata.jfx.bind.Validations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableValue;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationsImpl
implements Validations {
    private static final Logger log = LoggerFactory.getLogger(ValidationsImpl.class);
    private Collection<? extends BindForm> bindForms;
    private final Map<Class<?>, ValidationStatus> validations = new HashMap();
    private Binder rootBinder;

    public ValidationsImpl(Binder rootBinder, @NonNull Collection<? extends BindForm> bindForms) {
        if (bindForms == null) {
            throw new NullPointerException("bindForms");
        }
        this.rootBinder = rootBinder;
        this.bindForms = bindForms;
    }

    public void rebind(Collection<? extends BindForm> bindForms) {
        Validate.notNull(bindForms);
        this.bindForms = bindForms;
        for (ValidationStatus status : this.validations.values()) {
            status.rebind(bindForms);
        }
    }

    @Override
    public void addValidationGroup(Class<?> validationGroup) {
        if (this.validations.containsKey(validationGroup)) {
            return;
        }
        ValidationStatus status = new ValidationStatus(this.rootBinder, validationGroup, this.bindForms);
        this.validations.put(validationGroup, status);
    }

    @Override
    public void removeValidationGroup(Class<?> validationGroup) {
        ValidationStatus status = this.validations.remove(validationGroup);
        status.unbind();
        for (BindForm bindForm : this.bindForms) {
            bindForm.getValidationActive(validationGroup).unbind();
            bindForm.removeValidationGroup(validationGroup);
        }
    }

    @Override
    public BooleanProperty getValidationActive(Class<?> validationGroup) {
        Validate.notNull(validationGroup);
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.isTrue((status != null ? 1 : 0) != 0, (String)"The validation group %s was not defined", (Object[])new Object[]{validationGroup.getSimpleName()});
        return status.activeProperty();
    }

    @Override
    public ReadOnlyBooleanProperty getFormValidProperty(Class<?> validationGroup) {
        Validate.notNull(validationGroup);
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.isTrue((status != null ? 1 : 0) != 0, (String)"The validation group %s was not defined", (Object[])new Object[]{validationGroup.getSimpleName()});
        if (!status.isValid()) {
            log.debug("form not valid for group {} invalid properties = {} ", (Object)validationGroup.getSimpleName(), status.getInvalidProperties().get());
        }
        return status.validProperty();
    }

    @Override
    public void setValid(String propertyName, Class<?> validationGroup) {
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.validState((status != null ? 1 : 0) != 0, (String)"Could not set valid status for property %s in validation group %s as the validation group is missing", (Object[])new Object[]{propertyName, validationGroup.getSimpleName()});
        status.setValid(propertyName);
    }

    @Override
    public void setInvalid(String propertyName, Class<?> validationGroup) {
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.validState((status != null ? 1 : 0) != 0, (String)"Could not set invalid status for property %s in validation group %s as the validation group is missing", (Object[])new Object[]{propertyName, validationGroup.getSimpleName()});
        log.debug("invalidProperty {} group {}", (Object)propertyName, validationGroup);
        status.setInvalid(propertyName);
    }

    @Override
    public Set<Class<?>> getValidations() {
        return this.validations.keySet();
    }

    public void unbind() {
        for (Class<?> validationGroup : this.validations.keySet()) {
            this.removeValidationGroup(validationGroup);
        }
    }

    @Override
    public void setValidationRequired() {
        for (BindForm bindForm : this.bindForms) {
            bindForm.setValidationRequired();
        }
    }

    public void setRootBinder(Binder binder) {
        this.rootBinder = binder;
        for (ValidationStatus status : this.validations.values()) {
            status.setRootBinder(this.rootBinder);
        }
    }

    public void clear() {
        for (ValidationStatus validationStatus : this.validations.values()) {
            log.debug("Clearing invalid properties for {}, invalidProps = {}", (Object)validationStatus, validationStatus.getInvalidProperties().get());
            validationStatus.clearInvalidProperties();
            log.debug("After clearing invalid properties for {}, invalidProps = {}", (Object)validationStatus, validationStatus.getInvalidProperties().get());
        }
        for (BindForm bindForm : this.bindForms) {
            for (Class<?> s : new ArrayList(bindForm.getValidations())) {
                log.debug("clearing bindForm ={} for group {}", (Object)bindForm, s);
                BooleanProperty bp = bindForm.getValidationActive(s);
                bindForm.removeValidationGroup(s);
                bindForm.addValidationGroup(s);
                bindForm.getValidationActive(s).bind((ObservableValue)bp);
                log.debug("after clearing bindForm ={} for group {} valid={}", new Object[]{bindForm, s, bindForm.getFormValidProperty(s)});
            }
        }
        this.debugStatus();
    }

    public void debugStatus() {
        for (ValidationStatus vs : this.validations.values()) {
            log.debug("status:: group {} invalidProps {}= props valid={} invalidForms {} validForms {} forms Valid ={} formsValid={} valid={} active={}", new Object[]{vs.getValidationGroup(), vs.getInvalidProperties().get(), vs.isPropertiesValid(), vs.getInvalidForms(), vs.getValidForms(), vs.isFormsValid(), vs.isValid(), vs.activeProperty().get()});
        }
    }
}

