/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.binding.BooleanArrayBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationStatus {
    private static final Logger log = LoggerFactory.getLogger(ValidationStatus.class);
    private Binder rootBinder;
    private final Class<?> validationGroup;
    private final SetProperty<String> invalidProperties = new SimpleSetProperty(FXCollections.observableSet(new HashSet()));
    private BooleanArrayBinding formsValid;
    private final BooleanProperty valid = new SimpleBooleanProperty(true);
    private final BooleanProperty active = new SimpleBooleanProperty(true);
    private Collection<? extends BindForm> bindForms;

    public ValidationStatus(@NonNull Binder rootBinder, @NonNull Class<?> validationGroup, @NonNull Collection<? extends BindForm> newBindForms) {
        if (rootBinder == null) {
            throw new NullPointerException("rootBinder");
        }
        if (validationGroup == null) {
            throw new NullPointerException("validationGroup");
        }
        if (newBindForms == null) {
            throw new NullPointerException("newBindForms");
        }
        this.rootBinder = rootBinder;
        this.validationGroup = validationGroup;
        this.bindForms = newBindForms;
        ArrayList<ReadOnlyBooleanProperty> binds = new ArrayList<ReadOnlyBooleanProperty>();
        for (BindForm bindForm : newBindForms) {
            bindForm.addValidationGroup(validationGroup);
            bindForm.getValidationActive(validationGroup).bind((ObservableValue)this.active);
            binds.add(bindForm.getFormValidProperty(validationGroup));
        }
        this.formsValid = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.AND, (Collection<? extends BooleanExpression>)binds);
        this.valid.bind((ObservableValue)this.active.not().or((ObservableBooleanValue)this.invalidProperties.emptyProperty().and((ObservableBooleanValue)this.formsValid)));
        this.active.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                ValidationStatus.this.rootBinder.setValidationRequired();
            }
        });
    }

    public void rebind(Collection<? extends BindForm> newBindForms) {
        Validate.notNull(newBindForms);
        this.valid.unbind();
        for (BindForm bindForm : this.bindForms) {
            if (!bindForm.getValidations().contains(this.validationGroup)) continue;
            bindForm.getValidationActive(this.validationGroup).unbind();
        }
        ArrayList<ReadOnlyBooleanProperty> binds = new ArrayList<ReadOnlyBooleanProperty>();
        this.bindForms = newBindForms;
        for (BindForm bindForm : newBindForms) {
            bindForm.addValidationGroup(this.validationGroup);
            bindForm.getValidationActive(this.validationGroup).bind((ObservableValue)this.active);
            binds.add(bindForm.getFormValidProperty(this.validationGroup));
        }
        this.formsValid = new BooleanArrayBinding(BooleanArrayBinding.BindingMode.AND, (Collection<? extends BooleanExpression>)binds);
        this.valid.bind((ObservableValue)this.active.not().or((ObservableBooleanValue)this.invalidProperties.emptyProperty().and((ObservableBooleanValue)this.formsValid)));
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public boolean isFormsValid() {
        return this.formsValid.get();
    }

    public boolean isPropertiesValid() {
        return this.invalidProperties.isEmpty();
    }

    public void unbind() {
        this.valid.unbind();
    }

    public void setValid(String propertyName) {
        Validate.notNull((Object)propertyName);
        this.invalidProperties.remove((Object)propertyName);
    }

    public void setInvalid(String propertyName) {
        Validate.notNull((Object)propertyName);
        this.invalidProperties.add((Object)propertyName);
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public void clearInvalidProperties() {
        this.invalidProperties.clear();
    }

    public List<BindForm> getInvalidForms() {
        Stream<? extends BindForm> s = this.bindForms.stream();
        s = s.filter(bf -> !bf.getFormValidProperty(this.validationGroup).get());
        return s.collect(Collectors.toList());
    }

    public List<BindForm> getValidForms() {
        Stream<? extends BindForm> s = this.bindForms.stream();
        s = s.filter(bf -> bf.getFormValidProperty(this.validationGroup).get());
        return s.collect(Collectors.toList());
    }

    public void setRootBinder(Binder rootBinder) {
        this.rootBinder = rootBinder;
    }

    public Class<?> getValidationGroup() {
        return this.validationGroup;
    }

    public SetProperty<String> getInvalidProperties() {
        return this.invalidProperties;
    }
}

