/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.layer;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import org.lodgon.openmapfx.core.BaseMapProvider;
import org.lodgon.openmapfx.core.LayeredMap;
import org.lodgon.openmapfx.core.MapLayer;
import org.lodgon.openmapfx.core.TileProvider;

public class LicenceLayer
extends AnchorPane
implements MapLayer {
    private Label lblLicence;
    private BaseMapProvider provider;
    private final ChangeListener<TileProvider> tileProviderListener = (obs, o, n) -> this.updateLicence((TileProvider)n);

    public LicenceLayer(BaseMapProvider provider) {
        this.provider = provider;
        this.provider.tileProviderProperty().addListener(this.tileProviderListener);
        this.lblLicence = new Label();
        this.lblLicence.setText("");
        this.lblLicence.setStyle("-fx-background-color:rgba(66%,66%,66%,0.5)");
        AnchorPane.setLeftAnchor((Node)this.lblLicence, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.lblLicence, (Double)0.0);
        this.getChildren().add((Object)this.lblLicence);
        this.updateLicence((TileProvider)provider.tileProviderProperty().get());
    }

    public void setBaseMapProvider(BaseMapProvider provider) {
        this.provider.tileProviderProperty().removeListener(this.tileProviderListener);
        this.provider = provider;
        this.provider.tileProviderProperty().addListener(this.tileProviderListener);
        this.updateLicence((TileProvider)provider.tileProviderProperty().get());
    }

    private void updateLicence(TileProvider tileProvider) {
        if (tileProvider != null) {
            this.lblLicence.setText(tileProvider.getAttributionNotice());
        } else {
            this.lblLicence.setText("");
        }
    }

    @Override
    public Node getView() {
        return this;
    }

    @Override
    public void gotLayeredMap(LayeredMap map) {
        this.minWidthProperty().bind((ObservableValue)map.widthProperty());
        this.minHeightProperty().bind((ObservableValue)map.heightProperty());
    }
}

