/*
 * Decompiled with CFR 0.152.
 */
package org.lodgon.openmapfx.core;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import org.lodgon.openmapfx.core.MapArea;
import org.lodgon.openmapfx.core.MapTileType;

public class MapTile
extends Region {
    private final MapArea mapArea;
    private final int myZoom;
    private final long i;
    private final long j;
    private final List<MapTile> covering = new LinkedList<MapTile>();
    private boolean debug = false;
    private Label debugLabel = new Label();
    static AtomicInteger createcnt = new AtomicInteger(0);
    final Scale scale = new Scale();
    private final InvalidationListener zl;
    private final InvalidationListener ipl;
    private final BooleanProperty loading = new SimpleBooleanProperty();
    private final MapTile parentTile;
    private final Image image;

    public MapTile(MapArea mapArea, int zoom, long i, long j) {
        int ig = createcnt.incrementAndGet();
        if (this.debug) {
            System.out.println("Create tile #" + ig);
        }
        this.mapArea = mapArea;
        this.myZoom = zoom;
        this.i = i;
        this.j = j;
        this.scale.setPivotX(0.0);
        this.scale.setPivotY(0.0);
        this.getTransforms().add((Object)this.scale);
        String url = ((MapTileType)mapArea.tileTypeProperty().get()).getBaseURL(zoom, i, j);
        if (this.debug) {
            System.out.println("Creating maptile " + (Object)((Object)this) + " with url = " + url);
        }
        this.image = new Image(url, true);
        this.loading.bind((ObservableValue)this.image.progressProperty().lessThan(1.0));
        ImageView iv = new ImageView(this.image);
        if (this.debug) {
            this.debugLabel.setText("[" + zoom + "-" + i + "-" + j + "]");
        }
        this.getChildren().addAll((Object[])new Node[]{iv, this.debugLabel});
        this.parentTile = mapArea.findCovering(zoom, i, j);
        if (this.parentTile != null) {
            if (this.debug) {
                System.out.println("[JVDBG] ASK " + (Object)((Object)this.parentTile) + " to cover for " + (Object)((Object)this));
            }
            this.parentTile.addCovering(this);
        }
        this.ipl = this.createImageProgressListener();
        this.image.progressProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.ipl));
        if (this.image.getProgress() >= 1.0) {
            if (this.debug) {
                System.out.println("[JVDBG] ASK " + (Object)((Object)this.parentTile) + " to NOWFORGET for " + (Object)((Object)this));
            }
            this.parentTile.removeCovering(this);
        }
        this.zl = this.recalculate();
        mapArea.zoomProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.zl));
        mapArea.translateXProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.zl));
        mapArea.translateYProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.zl));
        this.calculatePosition();
    }

    public int getZoomLevel() {
        return this.myZoom;
    }

    public boolean loading() {
        return this.loading.get();
    }

    public void addCovering(MapTile me) {
        this.covering.add(me);
        this.setVisible(true);
    }

    public void removeCovering(MapTile me) {
        this.covering.remove((Object)me);
        this.calculatePosition();
    }

    public MapTile getCoveringTile() {
        return this.parentTile;
    }

    public boolean isCovering() {
        return this.covering.size() > 0;
    }

    public String toString() {
        return "Tile[" + this.myZoom + "]" + " " + this.i + ", " + this.j;
    }

    private InvalidationListener recalculate() {
        return o -> this.calculatePosition();
    }

    private InvalidationListener createImageProgressListener() {
        InvalidationListener answer = o -> {
            double progress = this.image.getProgress();
            if (progress >= 1.0 && this.parentTile != null) {
                if (this.debug) {
                    System.out.println("[JVDBG] ASK " + (Object)((Object)this.parentTile) + " to FORGET cover for " + (Object)((Object)this));
                }
                this.parentTile.removeCovering(this);
            }
        };
        return answer;
    }

    private void calculatePosition() {
        double currentZoom = this.mapArea.zoomProperty().get();
        int visibleWindow = (int)Math.floor(currentZoom + 0.2);
        if (visibleWindow == this.myZoom || this.isCovering() || visibleWindow >= 20 && this.myZoom == 19) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        if (this.debug) {
            System.out.println("visible tile " + (Object)((Object)this) + "? " + this.isVisible() + (this.isVisible() ? " covering? " + this.isCovering() : ""));
            if (this.isVisible() && this.isCovering()) {
                System.out.println("covering for " + this.covering);
            }
        }
        double sf = Math.pow(2.0, currentZoom - (double)this.myZoom);
        this.scale.setX(sf);
        this.scale.setY(sf);
        this.setTranslateX((double)(256L * this.i) * sf);
        this.setTranslateY((double)(256L * this.j) * sf);
    }
}

