/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.scene.control.AutoCompleteComboBox;
import com.anahata.jfx.scene.control.DisplayableCell;
import com.anahata.util.formatting.Displayable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import org.apache.commons.lang3.Validate;

public class DisplayableListCellFactory<T extends Displayable>
implements Callback<ListView<T>, ListCell<T>> {
    public ListCell<T> call(ListView<T> p) {
        return new ListCell<T>(){

            protected void updateItem(T displayable, boolean empty) {
                super.updateItem(displayable, empty);
                DisplayableCell.updateItem((IndexedCell)this, displayable, empty);
            }
        };
    }

    public static void setComboBoxCellFactory(ComboBox<? extends Displayable> comboBox) {
        Validate.notNull(comboBox);
        DisplayableListCellFactory cellFactory = new DisplayableListCellFactory();
        comboBox.setCellFactory(cellFactory);
        comboBox.setButtonCell(cellFactory.call(null));
    }

    public static void setComboBoxCellFactory(AutoCompleteComboBox<? extends Displayable> comboBox) {
        Validate.notNull(comboBox);
        DisplayableListCellFactory cellFactory = new DisplayableListCellFactory();
        comboBox.setCellFactory(cellFactory);
    }
}

