/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.scene.control;

import com.anahata.jfx.bind.nodemodel.NodeModel;
import com.anahata.util.formatting.Displayable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.Validate;

public class CheckboxList<T>
extends VBox
implements NodeModel<CheckboxList, SetProperty> {
    private final SetProperty<T> value = new SimpleSetProperty();

    public ObservableSet<T> getValue() {
        return (ObservableSet)this.value.get();
    }

    public void setValue(ObservableSet<T> value) {
        this.value.set(value);
    }

    public SetProperty<T> valueProperty() {
        return this.value;
    }

    public void init(T[] values) {
        this.init(Arrays.asList(values));
    }

    public void init(Collection<T> values) {
        Validate.notNull(values);
        super.setPrefHeight(-1.0);
        super.setMinHeight(Double.NEGATIVE_INFINITY);
        super.setSpacing(8.0);
        this.value.set((Object)FXCollections.observableSet(new HashSet()));
        for (T currValue : values) {
            String description = currValue instanceof Displayable ? ((Displayable)currValue).getDisplayValue() : currValue.toString();
            final CheckBox cb = new CheckBox(description);
            cb.setUserData(currValue);
            this.getChildren().add((Object)cb);
            cb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                    Object eValue = cb.getUserData();
                    if (newValue.booleanValue()) {
                        ((ObservableSet)CheckboxList.this.value.get()).add(eValue);
                    } else {
                        ((ObservableSet)CheckboxList.this.value.get()).remove(eValue);
                    }
                }
            });
        }
        this.value.addListener(new ChangeListener<Set<T>>(){

            public void changed(ObservableValue<? extends Set<T>> ov, Set<T> oldValue, Set<T> newValue) {
                for (Node node : CheckboxList.this.getChildren()) {
                    CheckBox cb = (CheckBox)node;
                    Object currValue = cb.getUserData();
                    cb.setSelected(newValue != null && newValue.contains(currValue));
                }
            }
        });
        this.setStyle("-fx-border: solid 2px red;");
    }

    @Override
    public SetProperty getNodeModelValueProperty(CheckboxList node) {
        return node.valueProperty();
    }
}

