/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.jfx.bind;

import com.anahata.jfx.bind.BindForm;
import com.anahata.jfx.bind.Binder;
import com.anahata.jfx.bind.ValidationStatus;
import com.anahata.jfx.bind.Validations;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class ValidationsImpl
implements Validations {
    private Collection<? extends BindForm> bindForms;
    private final Map<Class<?>, ValidationStatus> validations = new HashMap();
    private Binder rootBinder;

    public ValidationsImpl(Binder rootBinder, @NonNull Collection<? extends BindForm> bindForms) {
        if (bindForms == null) {
            throw new NullPointerException("bindForms");
        }
        this.rootBinder = rootBinder;
        this.bindForms = bindForms;
    }

    public void rebind(Collection<? extends BindForm> bindForms) {
        Validate.notNull(bindForms);
        this.bindForms = bindForms;
        for (ValidationStatus status : this.validations.values()) {
            status.rebind(bindForms);
        }
    }

    @Override
    public void addValidationGroup(Class<?> validationGroup) {
        if (this.validations.containsKey(validationGroup)) {
            return;
        }
        ValidationStatus status = new ValidationStatus(this.rootBinder, validationGroup, this.bindForms);
        this.validations.put(validationGroup, status);
    }

    @Override
    public void removeValidationGroup(Class<?> validationGroup) {
        ValidationStatus status = this.validations.remove(validationGroup);
        status.unbind();
        for (BindForm bindForm : this.bindForms) {
            bindForm.getValidationActive(validationGroup).unbind();
            bindForm.removeValidationGroup(validationGroup);
        }
    }

    @Override
    public BooleanProperty getValidationActive(Class<?> validationGroup) {
        Validate.notNull(validationGroup);
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.isTrue((status != null ? 1 : 0) != 0, (String)"The validation group %s was not defined", (Object[])new Object[]{validationGroup.getSimpleName()});
        return status.activeProperty();
    }

    @Override
    public ReadOnlyBooleanProperty getFormValidProperty(Class<?> validationGroup) {
        Validate.notNull(validationGroup);
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.isTrue((status != null ? 1 : 0) != 0, (String)"The validation group %s was not defined", (Object[])new Object[]{validationGroup.getSimpleName()});
        return status.validProperty();
    }

    @Override
    public void setValid(String propertyName, Class<?> validationGroup) {
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.validState((status != null ? 1 : 0) != 0, (String)"Could not set valid status for property %s in validation group %s as the validation group is missing", (Object[])new Object[]{propertyName, validationGroup.getSimpleName()});
        status.setValid(propertyName);
    }

    @Override
    public void setInvalid(String propertyName, Class<?> validationGroup) {
        ValidationStatus status = this.validations.get(validationGroup);
        Validate.validState((status != null ? 1 : 0) != 0, (String)"Could not set invalid status for property %s in validation group %s as the validation group is missing", (Object[])new Object[]{propertyName, validationGroup.getSimpleName()});
        status.setInvalid(propertyName);
    }

    @Override
    public Set<Class<?>> getValidations() {
        return this.validations.keySet();
    }

    public void unbind() {
        for (Class<?> validationGroup : this.validations.keySet()) {
            this.removeValidationGroup(validationGroup);
        }
    }

    @Override
    public void setValidationRequired() {
        for (BindForm bindForm : this.bindForms) {
            bindForm.setValidationRequired();
        }
    }

    public void setRootBinder(Binder binder) {
        this.rootBinder = binder;
        for (ValidationStatus status : this.validations.values()) {
            status.setRootBinder(this.rootBinder);
        }
    }
}

